/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dql.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import io.shardingjdbc.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingjdbc.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingjdbc.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingjdbc.core.parsing.parser.token.OffsetToken;
import io.shardingjdbc.core.parsing.parser.token.RowCountToken;
import io.shardingjdbc.core.parsing.parser.token.SQLToken;
import io.shardingjdbc.core.util.SQLUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SelectStatement
extends DQLStatement {
    private boolean containStar;
    private int selectListLastPosition;
    private int groupByLastPosition;
    private final Set<SelectItem> items = new HashSet<SelectItem>();
    private final List<OrderItem> groupByItems = new LinkedList<OrderItem>();
    private final List<OrderItem> orderByItems = new LinkedList<OrderItem>();
    private Limit limit;
    private SelectStatement subQueryStatement;

    public Optional<String> getAlias(String name) {
        if (this.containStar) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue(name);
        for (SelectItem each : this.items) {
            if (rawName.equalsIgnoreCase(SQLUtil.getExactlyValue(each.getExpression()))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    public List<AggregationSelectItem> getAggregationSelectItems() {
        LinkedList<AggregationSelectItem> result = new LinkedList<AggregationSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationSelectItem)) continue;
            AggregationSelectItem aggregationSelectItem = (AggregationSelectItem)each;
            result.add(aggregationSelectItem);
            for (AggregationSelectItem derivedEach : aggregationSelectItem.getDerivedAggregationSelectItems()) {
                result.add(derivedEach);
            }
        }
        return result;
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.getGroupByItems().isEmpty() && this.getGroupByItems().equals(this.getOrderByItems());
    }

    public void setIndexForItems(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationItem(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByItems);
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByItems);
    }

    private void setIndexForAggregationItem(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationSelectItem each : this.getAggregationSelectItems()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (Object)String.format("Can't find index: %s, please add alias for aggregate selections", each));
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (Object)String.format("Can't find index: %s", derived));
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            if (-1 != each.getIndex()) continue;
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (Object)String.format("Can't find index: %s", each));
            if (!columnLabelIndexMap.containsKey(each.getColumnLabel())) continue;
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
        }
    }

    public void setSubQueryStatement(SelectStatement subQueryStatement) {
        this.subQueryStatement = subQueryStatement;
        this.setParametersIndex(subQueryStatement.getParametersIndex());
    }

    public boolean containsSubQuery() {
        return null != this.subQueryStatement;
    }

    public SelectStatement mergeSubQueryStatement() {
        SelectStatement result = this.processLimitForSubQuery();
        this.processItems(result);
        this.processOrderByItems(result);
        return result;
    }

    private SelectStatement processLimitForSubQuery() {
        SelectStatement result = this;
        List<SQLToken> limitSQLTokens = this.getLimitTokens(result);
        Limit limit = result.getLimit();
        while (result.containsSubQuery()) {
            result = result.subQueryStatement;
            limitSQLTokens.addAll(this.getLimitTokens(result));
            if (null == result.getLimit()) continue;
            if (null == limit) {
                limit = result.getLimit();
            }
            if (null != result.getLimit().getRowCount()) {
                limit.setRowCount(result.getLimit().getRowCount());
            }
            if (null == result.getLimit().getOffset()) continue;
            limit.setOffset(result.getLimit().getOffset());
        }
        this.resetLimitTokens(result, limitSQLTokens);
        result.setLimit(limit);
        return result;
    }

    private List<SQLToken> getLimitTokens(SelectStatement selectStatement) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLToken each : selectStatement.getSqlTokens()) {
            if (!(each instanceof RowCountToken) && !(each instanceof OffsetToken)) continue;
            result.add(each);
        }
        return result;
    }

    private void resetLimitTokens(SelectStatement selectStatement, List<SQLToken> limitSQLTokens) {
        int count = 0;
        LinkedList<Integer> toBeRemovedIndexes = new LinkedList<Integer>();
        for (SQLToken each : selectStatement.getSqlTokens()) {
            if (each instanceof RowCountToken || each instanceof OffsetToken) {
                toBeRemovedIndexes.add(count);
            }
            ++count;
        }
        Iterator<SQLToken> i$ = toBeRemovedIndexes.iterator();
        while (i$.hasNext()) {
            int each = (Integer)((Object)i$.next());
            selectStatement.getSqlTokens().remove(each);
        }
        selectStatement.getSqlTokens().addAll(limitSQLTokens);
    }

    private void processItems(SelectStatement subQueryStatement) {
        if (!this.containStar) {
            subQueryStatement.getItems().clear();
            subQueryStatement.getItems().addAll(this.getItems());
        }
    }

    private void processOrderByItems(SelectStatement subQueryStatement) {
        if (!this.containStar) {
            subQueryStatement.getOrderByItems().clear();
            subQueryStatement.getGroupByItems().clear();
        }
    }

    public boolean isContainStar() {
        return this.containStar;
    }

    public int getSelectListLastPosition() {
        return this.selectListLastPosition;
    }

    public int getGroupByLastPosition() {
        return this.groupByLastPosition;
    }

    public Set<SelectItem> getItems() {
        return this.items;
    }

    public List<OrderItem> getGroupByItems() {
        return this.groupByItems;
    }

    public List<OrderItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setContainStar(boolean containStar) {
        this.containStar = containStar;
    }

    public void setSelectListLastPosition(int selectListLastPosition) {
        this.selectListLastPosition = selectListLastPosition;
    }

    public void setGroupByLastPosition(int groupByLastPosition) {
        this.groupByLastPosition = groupByLastPosition;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    @Override
    public String toString() {
        return "SelectStatement(super=" + super.toString() + ", containStar=" + this.isContainStar() + ", selectListLastPosition=" + this.getSelectListLastPosition() + ", groupByLastPosition=" + this.getGroupByLastPosition() + ", items=" + this.getItems() + ", groupByItems=" + this.getGroupByItems() + ", orderByItems=" + this.getOrderByItems() + ", limit=" + this.getLimit() + ", subQueryStatement=" + this.subQueryStatement + ")";
    }
}

