/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.router;

import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.parsing.SQLJudgeEngine;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.routing.SQLExecutionUnit;
import io.shardingjdbc.core.routing.SQLRouteResult;
import io.shardingjdbc.core.routing.router.SQLRouter;
import io.shardingjdbc.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.routing.type.hint.DatabaseHintRoutingEngine;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLLogger;
import java.util.List;

public final class DatabaseHintSQLRouter
implements SQLRouter {
    private final ShardingRule shardingRule;
    private final boolean showSQL;

    public DatabaseHintSQLRouter(ShardingContext shardingContext) {
        this.shardingRule = shardingContext.getShardingRule();
        this.showSQL = shardingContext.isShowSQL();
    }

    @Override
    public SQLStatement parse(String logicSQL, int parametersSize) {
        return new SQLJudgeEngine(logicSQL).judge();
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        RoutingResult routingResult = new DatabaseHintRoutingEngine(this.shardingRule.getDataSourceMap(), (HintShardingStrategy)this.shardingRule.getDefaultDatabaseShardingStrategy()).route();
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), logicSQL));
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getExecutionUnits(), parameters);
        }
        return result;
    }
}

