/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import io.shardingjdbc.orchestration.reg.listener.DataChangedEvent;
import io.shardingjdbc.orchestration.reg.listener.EventListener;
import java.sql.SQLException;

public final class ConfigurationListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;
    private final DataSourceService dataSourceService;

    public ConfigurationListenerManager(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
        this.dataSourceService = new DataSourceService(name, regCenter);
    }

    @Override
    public void start(ShardingDataSource shardingDataSource) {
        this.start("config/datasource", shardingDataSource);
        this.start("config/sharding/rule", shardingDataSource);
        this.start("config/sharding/props", shardingDataSource);
    }

    private void start(String node, final ShardingDataSource shardingDataSource) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.watch(cachePath, new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    try {
                        shardingDataSource.renew(ConfigurationListenerManager.this.dataSourceService.getAvailableShardingRuleConfiguration().build(ConfigurationListenerManager.this.dataSourceService.getAvailableDataSources()), ConfigurationListenerManager.this.configService.loadShardingProperties());
                    }
                    catch (SQLException ex) {
                        throw new ShardingJdbcException((Exception)ex);
                    }
                }
            }
        });
    }

    @Override
    public void start(MasterSlaveDataSource masterSlaveDataSource) {
        this.start("config/datasource", masterSlaveDataSource);
        this.start("config/masterslave/rule", masterSlaveDataSource);
    }

    private void start(String node, final MasterSlaveDataSource masterSlaveDataSource) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.watch(cachePath, new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    masterSlaveDataSource.renew(ConfigurationListenerManager.this.dataSourceService.getAvailableMasterSlaveRuleConfiguration().build(ConfigurationListenerManager.this.dataSourceService.getAvailableDataSources()));
                }
            }
        });
    }
}

