/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.json;

import com.google.gson.reflect.TypeToken;
import io.shardingjdbc.core.jdbc.core.datasource.NamedDataSource;
import io.shardingjdbc.orchestration.internal.json.DataSourceGsonTypeAdapter;
import io.shardingjdbc.orchestration.internal.json.GsonFactory;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceJsonConverter {
    public static String toJson(Map<String, DataSource> dataSources) {
        LinkedList<NamedDataSource> result = new LinkedList<NamedDataSource>();
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            result.add(new NamedDataSource(entry.getKey(), entry.getValue()));
        }
        return GsonFactory.getGson().toJson(result);
    }

    public static Map<String, DataSource> fromJson(String json) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        List namedDataSources = (List)GsonFactory.getGson().fromJson(json, new TypeToken<List<NamedDataSource>>(){}.getType());
        for (NamedDataSource each : namedDataSources) {
            result.put(each.getName(), each.getDataSource());
        }
        return result;
    }

    private DataSourceJsonConverter() {
    }

    static {
        GsonFactory.registerTypeAdapter(NamedDataSource.class, new DataSourceGsonTypeAdapter());
    }
}

