/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.api;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.executor.threadlocal.ExecutorExceptionHandler;
import io.shardingjdbc.core.jdbc.core.connection.ShardingConnection;
import io.shardingjdbc.transaction.api.SoftTransactionManager;
import io.shardingjdbc.transaction.constants.SoftTransactionType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;

public abstract class AbstractSoftTransaction {
    private boolean previousAutoCommit;
    private ShardingConnection connection;
    private SoftTransactionType transactionType;
    private String transactionId;

    protected final void beginInternal(Connection conn, SoftTransactionType type) throws SQLException {
        Preconditions.checkArgument((boolean)(conn instanceof ShardingConnection), (Object)"Only ShardingConnection can support eventual consistency transaction.");
        ExecutorExceptionHandler.setExceptionThrown((boolean)false);
        this.connection = (ShardingConnection)conn;
        this.transactionType = type;
        this.previousAutoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(true);
        this.transactionId = UUID.randomUUID().toString();
    }

    public final void end() throws SQLException {
        if (null != this.connection) {
            ExecutorExceptionHandler.setExceptionThrown((boolean)true);
            this.connection.setAutoCommit(this.previousAutoCommit);
            SoftTransactionManager.closeCurrentTransactionManager();
        }
    }

    public ShardingConnection getConnection() {
        return this.connection;
    }

    public SoftTransactionType getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionId() {
        return this.transactionId;
    }
}

