/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.executor.threadlocal.ExecutorDataMap;
import io.shardingjdbc.core.util.EventBusInstance;
import io.shardingjdbc.transaction.api.AbstractSoftTransaction;
import io.shardingjdbc.transaction.api.config.SoftTransactionConfiguration;
import io.shardingjdbc.transaction.bed.BEDSoftTransaction;
import io.shardingjdbc.transaction.bed.async.NestedBestEffortsDeliveryJobFactory;
import io.shardingjdbc.transaction.bed.sync.BestEffortsDeliveryListener;
import io.shardingjdbc.transaction.constants.SoftTransactionType;
import io.shardingjdbc.transaction.constants.TransactionLogDataSourceType;
import io.shardingjdbc.transaction.tcc.TCCSoftTransaction;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class SoftTransactionManager {
    private static final String TRANSACTION = "transaction";
    private static final String TRANSACTION_CONFIG = "transactionConfig";
    private final SoftTransactionConfiguration transactionConfig;

    public void init() throws SQLException {
        EventBusInstance.getInstance().register((Object)new BestEffortsDeliveryListener());
        if (TransactionLogDataSourceType.RDB == this.transactionConfig.getStorageType()) {
            Preconditions.checkNotNull((Object)this.transactionConfig.getTransactionLogDataSource());
            this.createTable();
        }
        if (this.transactionConfig.getBestEffortsDeliveryJobConfiguration().isPresent()) {
            new NestedBestEffortsDeliveryJobFactory(this.transactionConfig).init();
        }
    }

    private void createTable() throws SQLException {
        String dbSchema = "CREATE TABLE IF NOT EXISTS `transaction_log` (`id` VARCHAR(40) NOT NULL, `transaction_type` VARCHAR(30) NOT NULL, `data_source` VARCHAR(255) NOT NULL, `sql` TEXT NOT NULL, `parameters` TEXT NOT NULL, `creation_time` LONG NOT NULL, `async_delivery_try_times` INT NOT NULL DEFAULT 0, PRIMARY KEY (`id`));";
        try (Connection conn = this.transactionConfig.getTransactionLogDataSource().getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(dbSchema);){
            preparedStatement.executeUpdate();
        }
    }

    public AbstractSoftTransaction getTransaction(SoftTransactionType type) {
        AbstractSoftTransaction result;
        switch (type) {
            case BestEffortsDelivery: {
                result = new BEDSoftTransaction();
                break;
            }
            case TryConfirmCancel: {
                result = new TCCSoftTransaction();
                break;
            }
            default: {
                throw new UnsupportedOperationException(type.toString());
            }
        }
        if (SoftTransactionManager.getCurrentTransaction().isPresent()) {
            throw new UnsupportedOperationException("Cannot support nested transaction.");
        }
        ExecutorDataMap.getDataMap().put(TRANSACTION, result);
        ExecutorDataMap.getDataMap().put(TRANSACTION_CONFIG, this.transactionConfig);
        return result;
    }

    public static Optional<SoftTransactionConfiguration> getCurrentTransactionConfiguration() {
        Object transactionConfig = ExecutorDataMap.getDataMap().get(TRANSACTION_CONFIG);
        return null == transactionConfig ? Optional.absent() : Optional.of((Object)((SoftTransactionConfiguration)transactionConfig));
    }

    public static Optional<AbstractSoftTransaction> getCurrentTransaction() {
        Object transaction = ExecutorDataMap.getDataMap().get(TRANSACTION);
        return null == transaction ? Optional.absent() : Optional.of((Object)((AbstractSoftTransaction)transaction));
    }

    static void closeCurrentTransactionManager() {
        ExecutorDataMap.getDataMap().put(TRANSACTION, null);
        ExecutorDataMap.getDataMap().put(TRANSACTION_CONFIG, null);
    }

    @ConstructorProperties(value={"transactionConfig"})
    public SoftTransactionManager(SoftTransactionConfiguration transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public SoftTransactionConfiguration getTransactionConfig() {
        return this.transactionConfig;
    }
}

