/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.api.config;

import com.google.common.base.Optional;
import io.shardingjdbc.core.constant.SQLType;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.transaction.api.config.NestedBestEffortsDeliveryJobConfiguration;
import io.shardingjdbc.transaction.constants.TransactionLogDataSourceType;
import io.shardingjdbc.transaction.datasource.TransactionLogDataSource;
import io.shardingjdbc.transaction.datasource.impl.MemoryTransactionLogDataSource;
import io.shardingjdbc.transaction.datasource.impl.RdbTransactionLogDataSource;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SoftTransactionConfiguration {
    private final DataSource targetDataSource;
    private int syncMaxDeliveryTryTimes = 3;
    private TransactionLogDataSourceType storageType = TransactionLogDataSourceType.RDB;
    private DataSource transactionLogDataSource;
    private Optional<NestedBestEffortsDeliveryJobConfiguration> bestEffortsDeliveryJobConfiguration = Optional.absent();

    public Connection getTargetConnection(String dataSourceName) throws SQLException {
        if (!(this.targetDataSource instanceof ShardingDataSource)) {
            return this.targetDataSource.getConnection();
        }
        return ((ShardingDataSource)this.targetDataSource).getConnection().getConnection(dataSourceName, SQLType.DQL);
    }

    public TransactionLogDataSource buildTransactionLogDataSource() {
        MemoryTransactionLogDataSource result;
        switch (this.storageType) {
            case MEMORY: {
                result = new MemoryTransactionLogDataSource();
                break;
            }
            case RDB: {
                result = new RdbTransactionLogDataSource(this.transactionLogDataSource);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    @ConstructorProperties(value={"targetDataSource"})
    public SoftTransactionConfiguration(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public int getSyncMaxDeliveryTryTimes() {
        return this.syncMaxDeliveryTryTimes;
    }

    public TransactionLogDataSourceType getStorageType() {
        return this.storageType;
    }

    public DataSource getTransactionLogDataSource() {
        return this.transactionLogDataSource;
    }

    public Optional<NestedBestEffortsDeliveryJobConfiguration> getBestEffortsDeliveryJobConfiguration() {
        return this.bestEffortsDeliveryJobConfiguration;
    }

    public void setSyncMaxDeliveryTryTimes(int syncMaxDeliveryTryTimes) {
        this.syncMaxDeliveryTryTimes = syncMaxDeliveryTryTimes;
    }

    public void setStorageType(TransactionLogDataSourceType storageType) {
        this.storageType = storageType;
    }

    public void setTransactionLogDataSource(DataSource transactionLogDataSource) {
        this.transactionLogDataSource = transactionLogDataSource;
    }

    public void setBestEffortsDeliveryJobConfiguration(Optional<NestedBestEffortsDeliveryJobConfiguration> bestEffortsDeliveryJobConfiguration) {
        this.bestEffortsDeliveryJobConfiguration = bestEffortsDeliveryJobConfiguration;
    }
}

