/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.bed.async;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.JobScheduler;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.reg.zookeeper.ZookeeperRegistryCenter;
import io.shardingjdbc.transaction.api.config.AbstractBestEffortsDeliveryJobConfiguration;
import io.shardingjdbc.transaction.api.config.SoftTransactionConfiguration;
import io.shardingjdbc.transaction.bed.async.NestedBestEffortsDeliveryJob;
import io.shardingjdbc.transaction.datasource.TransactionLogDataSource;
import io.shardingjdbc.transaction.storage.TransactionLogStorageFactory;
import java.beans.ConstructorProperties;

public abstract class AbstractBestEffortsDeliveryJobFactory<T extends AbstractBestEffortsDeliveryJobConfiguration> {
    private final SoftTransactionConfiguration transactionConfig;

    public final void init() {
        AbstractBestEffortsDeliveryJobConfiguration bedJobConfig = (AbstractBestEffortsDeliveryJobConfiguration)this.transactionConfig.getBestEffortsDeliveryJobConfiguration().get();
        ZookeeperRegistryCenter regCenter = new ZookeeperRegistryCenter(this.createZookeeperConfiguration(bedJobConfig));
        regCenter.init();
        JobScheduler jobScheduler = new JobScheduler((CoordinatorRegistryCenter)regCenter, this.createBedJobConfiguration(bedJobConfig), new ElasticJobListener[0]);
        jobScheduler.setField("transactionConfig", (Object)this.transactionConfig);
        jobScheduler.setField("transactionLogStorage", (Object)TransactionLogStorageFactory.createTransactionLogStorage((TransactionLogDataSource)this.transactionConfig.buildTransactionLogDataSource()));
        jobScheduler.init();
    }

    protected abstract ZookeeperConfiguration createZookeeperConfiguration(T var1);

    private JobConfiguration createBedJobConfiguration(T bedJobConfig) {
        JobConfiguration result = new JobConfiguration(((AbstractBestEffortsDeliveryJobConfiguration)bedJobConfig).getJobName(), NestedBestEffortsDeliveryJob.class, 1, ((AbstractBestEffortsDeliveryJobConfiguration)bedJobConfig).getCron());
        result.setFetchDataCount(((AbstractBestEffortsDeliveryJobConfiguration)bedJobConfig).getTransactionLogFetchDataCount());
        return result;
    }

    @ConstructorProperties(value={"transactionConfig"})
    public AbstractBestEffortsDeliveryJobFactory(SoftTransactionConfiguration transactionConfig) {
        this.transactionConfig = transactionConfig;
    }
}

