/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.bed.async;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.dataflow.AbstractIndividualThroughputDataFlowElasticJob;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.transaction.api.config.NestedBestEffortsDeliveryJobConfiguration;
import io.shardingjdbc.transaction.api.config.SoftTransactionConfiguration;
import io.shardingjdbc.transaction.storage.TransactionLog;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedBestEffortsDeliveryJob
extends AbstractIndividualThroughputDataFlowElasticJob<TransactionLog> {
    private static final Logger log = LoggerFactory.getLogger(NestedBestEffortsDeliveryJob.class);
    private SoftTransactionConfiguration transactionConfig;
    private TransactionLogStorage transactionLogStorage;

    public List<TransactionLog> fetchData(JobExecutionMultipleShardingContext context) {
        return this.transactionLogStorage.findEligibleTransactionLogs(context.getFetchDataCount(), ((NestedBestEffortsDeliveryJobConfiguration)this.transactionConfig.getBestEffortsDeliveryJobConfiguration().get()).getAsyncMaxDeliveryTryTimes(), ((NestedBestEffortsDeliveryJobConfiguration)this.transactionConfig.getBestEffortsDeliveryJobConfiguration().get()).getAsyncMaxDeliveryTryDelayMillis());
    }

    public boolean processData(JobExecutionMultipleShardingContext context, TransactionLog data) {
        try {
            return this.transactionLogStorage.processData(this.transactionConfig.getTargetConnection(data.getDataSource()), data, ((NestedBestEffortsDeliveryJobConfiguration)this.transactionConfig.getBestEffortsDeliveryJobConfiguration().get()).getAsyncMaxDeliveryTryTimes());
        }
        catch (SQLException ex) {
            throw new ShardingJdbcException((Exception)ex);
        }
    }

    public boolean isStreamingProcess() {
        return false;
    }

    public void setTransactionConfig(SoftTransactionConfiguration transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public void setTransactionLogStorage(TransactionLogStorage transactionLogStorage) {
        this.transactionLogStorage = transactionLogStorage;
    }
}

