/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.bed.sync;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import io.shardingjdbc.core.constant.SQLType;
import io.shardingjdbc.core.executor.event.DMLExecutionEvent;
import io.shardingjdbc.transaction.api.AbstractSoftTransaction;
import io.shardingjdbc.transaction.api.SoftTransactionManager;
import io.shardingjdbc.transaction.api.config.SoftTransactionConfiguration;
import io.shardingjdbc.transaction.bed.BEDSoftTransaction;
import io.shardingjdbc.transaction.constants.SoftTransactionType;
import io.shardingjdbc.transaction.datasource.TransactionLogDataSource;
import io.shardingjdbc.transaction.storage.TransactionLog;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import io.shardingjdbc.transaction.storage.TransactionLogStorageFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BestEffortsDeliveryListener {
    private static final Logger log = LoggerFactory.getLogger(BestEffortsDeliveryListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void listen(DMLExecutionEvent event) {
        if (!this.isProcessContinuously()) {
            return;
        }
        SoftTransactionConfiguration transactionConfig = (SoftTransactionConfiguration)SoftTransactionManager.getCurrentTransactionConfiguration().get();
        TransactionLogStorage transactionLogStorage = TransactionLogStorageFactory.createTransactionLogStorage((TransactionLogDataSource)transactionConfig.buildTransactionLogDataSource());
        BEDSoftTransaction bedSoftTransaction = (BEDSoftTransaction)SoftTransactionManager.getCurrentTransaction().get();
        switch (event.getEventExecutionType()) {
            case BEFORE_EXECUTE: {
                transactionLogStorage.add(new TransactionLog(event.getId(), bedSoftTransaction.getTransactionId(), bedSoftTransaction.getTransactionType(), event.getDataSource(), event.getSql(), event.getParameters(), System.currentTimeMillis(), 0));
                return;
            }
            case EXECUTE_SUCCESS: {
                transactionLogStorage.remove(event.getId());
                return;
            }
            case EXECUTE_FAILURE: {
                boolean deliverySuccess = false;
                for (int i = 0; i < transactionConfig.getSyncMaxDeliveryTryTimes(); ++i) {
                    if (deliverySuccess) {
                        return;
                    }
                    boolean isNewConnection = false;
                    Connection conn = null;
                    PreparedStatement preparedStatement = null;
                    try {
                        conn = bedSoftTransaction.getConnection().getConnection(event.getDataSource(), SQLType.DML);
                        if (!this.isValidConnection(conn)) {
                            bedSoftTransaction.getConnection().release(conn);
                            conn = bedSoftTransaction.getConnection().getConnection(event.getDataSource(), SQLType.DML);
                            isNewConnection = true;
                        }
                        preparedStatement = conn.prepareStatement(event.getSql());
                        for (int parameterIndex = 0; parameterIndex < event.getParameters().size(); ++parameterIndex) {
                            preparedStatement.setObject(parameterIndex + 1, event.getParameters().get(parameterIndex));
                        }
                        preparedStatement.executeUpdate();
                        deliverySuccess = true;
                        transactionLogStorage.remove(event.getId());
                        this.close(isNewConnection, conn, preparedStatement);
                        continue;
                    }
                    catch (SQLException ex) {
                        try {
                            log.error(String.format("Delivery times %s error, max try times is %s", i + 1, transactionConfig.getSyncMaxDeliveryTryTimes()), (Throwable)ex);
                            this.close(isNewConnection, conn, preparedStatement);
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.close(isNewConnection, conn, preparedStatement);
                            throw throwable;
                        }
                    }
                }
                return;
            }
        }
        throw new UnsupportedOperationException(event.getEventExecutionType().toString());
    }

    private boolean isProcessContinuously() {
        return SoftTransactionManager.getCurrentTransaction().isPresent() && SoftTransactionType.BestEffortsDelivery == ((AbstractSoftTransaction)SoftTransactionManager.getCurrentTransaction().get()).getTransactionType();
    }

    /*
     * Exception decompiling
     */
    private boolean isValidConnection(Connection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void close(boolean isNewConnection, Connection conn, PreparedStatement preparedStatement) {
        if (null != preparedStatement) {
            try {
                preparedStatement.close();
            }
            catch (SQLException ex) {
                log.error("PreparedStatement closed error:", (Throwable)ex);
            }
        }
        if (isNewConnection && null != conn) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error("Connection closed error:", (Throwable)ex);
            }
        }
    }
}

