/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.executor;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.result.MemoryQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.shardingjdbc.executor.AbstractStatementExecutor;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public final class PreparedStatementExecutor
extends AbstractStatementExecutor {
    private final boolean returnGeneratedKeys;

    public PreparedStatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, ShardingConnection shardingConnection) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, shardingConnection);
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void init(SQLRouteResult routeResult) throws SQLException {
        this.setSqlType(routeResult.getSqlStatement().getType());
        this.getExecuteGroups().addAll(this.obtainExecuteGroups(routeResult.getRouteUnits()));
        this.cacheStatements();
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> obtainExecuteGroups(Collection<RouteUnit> routeUnits) throws SQLException {
        return this.getSqlExecutePrepareTemplate().getExecuteUnitGroups(routeUnits, new SQLExecutePrepareCallback(){

            public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
                return PreparedStatementExecutor.super.getConnection().getConnections(connectionMode, dataSourceName, connectionSize);
            }

            public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
                return new StatementExecuteUnit(routeUnit, (Statement)PreparedStatementExecutor.this.createPreparedStatement(connection, routeUnit.getSqlUnit().getSql()), connectionMode);
            }
        });
    }

    private PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
    }

    public List<QueryResult> executeQuery() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<QueryResult> executeCallback = new SQLExecuteCallback<QueryResult>(this.getDatabaseType(), this.getSqlType(), isExceptionThrown){

            protected QueryResult executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return PreparedStatementExecutor.this.getQueryResult(statementExecuteUnit);
            }
        };
        return this.executeCallback(executeCallback);
    }

    private QueryResult getQueryResult(StatementExecuteUnit statementExecuteUnit) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)statementExecuteUnit.getStatement();
        ResultSet resultSet = preparedStatement.executeQuery();
        this.getResultSets().add(resultSet);
        return ConnectionMode.MEMORY_STRICTLY == statementExecuteUnit.getConnectionMode() ? new StreamQueryResult(resultSet) : new MemoryQueryResult(resultSet);
    }

    public int executeUpdate() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Integer> executeCallback = new SQLExecuteCallback<Integer>(this.getDatabaseType(), this.getSqlType(), isExceptionThrown){

            protected Integer executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return ((PreparedStatement)statementExecuteUnit.getStatement()).executeUpdate();
            }
        };
        List<Integer> results = this.executeCallback(executeCallback);
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Boolean> executeCallback = new SQLExecuteCallback<Boolean>(this.getDatabaseType(), this.getSqlType(), isExceptionThrown){

            protected Boolean executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return ((PreparedStatement)statementExecuteUnit.getStatement()).execute();
            }
        };
        List<Boolean> result = this.executeCallback(executeCallback);
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }
}

