/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.transaction.TransactionTypeHolder;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingDataSource
extends AbstractDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ShardingDataSource.class);
    private final ShardingContext shardingContext;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(dataSourceMap);
        this.checkDataSourceType(dataSourceMap);
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getConfigMap().putAll(configMap);
        }
        this.shardingContext = new ShardingContext(this.getDataSourceMap(), shardingRule, this.getDatabaseType(), props);
    }

    private void checkDataSourceType(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            Preconditions.checkArgument((!(each instanceof MasterSlaveDataSource) ? 1 : 0) != 0, (Object)"Initialized data sources can not be master-slave data sources.");
        }
    }

    @Override
    public final ShardingConnection getConnection() {
        if (TransactionType.XA == TransactionTypeHolder.get()) {
            if (null != this.getXaDataSourceMap() && !this.getXaDataSourceMap().isEmpty()) {
                return new ShardingConnection(this.getXaDataSourceMap(), this.shardingContext, TransactionType.XA);
            }
            log.warn("XA transaction resource have not load, using Local transaction instead!");
        }
        return new ShardingConnection(this.getDataSourceMap(), this.shardingContext, TransactionType.LOCAL);
    }

    @Override
    public final void close() {
        super.close();
        this.shardingContext.close();
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

