/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.opentracing.hook;

import com.google.common.base.Joiner;
import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.shardingsphere.core.executor.ShardingExecuteDataMap;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.opentracing.ShardingTracer;
import io.shardingsphere.opentracing.constant.ShardingTags;
import io.shardingsphere.opentracing.hook.ShardingErrorSpan;
import io.shardingsphere.spi.executor.SQLExecutionHook;
import java.util.LinkedList;
import java.util.List;

public final class OpenTracingSQLExecutionHook
implements SQLExecutionHook {
    private static final String OPERATION_NAME = "/Sharding-Sphere/executeSQL/";
    private ActiveSpan activeSpan;
    private Span span;

    public void start(RouteUnit routeUnit, DataSourceMetaData dataSourceMetaData, boolean isTrunkThread) {
        if (!isTrunkThread) {
            this.activeSpan = ((ActiveSpan.Continuation)ShardingExecuteDataMap.getDataMap().get("ACTIVE_SPAN_CONTINUATION")).activate();
        }
        this.span = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "Sharding-Sphere").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.PEER_HOSTNAME.getKey(), dataSourceMetaData.getHostName()).withTag(Tags.PEER_PORT.getKey(), (Number)dataSourceMetaData.getPort()).withTag(Tags.DB_TYPE.getKey(), "sql").withTag(Tags.DB_INSTANCE.getKey(), routeUnit.getDataSourceName()).withTag(Tags.DB_STATEMENT.getKey(), routeUnit.getSqlUnit().getSql()).withTag(ShardingTags.DB_BIND_VARIABLES.getKey(), this.toString(routeUnit.getSqlUnit().getParameterSets())).startManual();
    }

    private String toString(List<List<Object>> parameterSets) {
        return parameterSets.isEmpty() ? "" : Joiner.on((String)", ").join(this.toStringList(parameterSets));
    }

    private List<String> toStringList(List<List<Object>> parameterSets) {
        LinkedList<String> result = new LinkedList<String>();
        for (List<Object> each : parameterSets) {
            result.add(String.format("[%s]", Joiner.on((String)", ").join(each)));
        }
        return result;
    }

    public void finishSuccess() {
        this.span.finish();
        if (null != this.activeSpan) {
            this.activeSpan.deactivate();
        }
    }

    public void finishFailure(Exception cause) {
        ShardingErrorSpan.setError(this.span, cause);
        this.span.finish();
        if (null != this.activeSpan) {
            this.activeSpan.deactivate();
        }
    }
}

