/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.opentracing.hook;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.shardingsphere.opentracing.ShardingTracer;
import io.shardingsphere.opentracing.hook.ShardingErrorSpan;
import io.shardingsphere.spi.parsing.ParsingHook;

public final class OpenTracingParsingHook
implements ParsingHook {
    private static final String OPERATION_NAME = "/Sharding-Sphere/parseSQL/";
    private Span span;

    public void start(String sql) {
        this.span = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "Sharding-Sphere").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.DB_STATEMENT.getKey(), sql).startManual();
    }

    public void finishSuccess() {
        this.span.finish();
    }

    public void finishFailure(Exception cause) {
        ShardingErrorSpan.setError(this.span, cause);
        this.span.finish();
    }
}

