/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.zookeeper.curator;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.api.RegistryCenterConfiguration;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;
import io.shardingsphere.orchestration.reg.zookeeper.curator.CuratorZookeeperExceptionHandler;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class CuratorZookeeperRegistryCenter
implements RegistryCenter {
    private final Map<String, TreeCache> caches = new HashMap<String, TreeCache>();
    private CuratorFramework client;

    public void init(RegistryCenterConfiguration config) {
        this.client = this.buildCuratorClient(config);
        this.initCuratorClient(config);
    }

    private CuratorFramework buildCuratorClient(RegistryCenterConfiguration config) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(config.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(config.getRetryIntervalMilliseconds(), config.getMaxRetries(), config.getRetryIntervalMilliseconds() * config.getMaxRetries())).namespace(config.getNamespace());
        if (0 != config.getTimeToLiveSeconds()) {
            builder.sessionTimeoutMs(config.getTimeToLiveSeconds() * 1000);
        }
        if (0 != config.getOperationTimeoutMilliseconds()) {
            builder.connectionTimeoutMs(config.getOperationTimeoutMilliseconds());
        }
        if (!Strings.isNullOrEmpty((String)config.getDigest())) {
            builder.authorization("digest", config.getDigest().getBytes(Charsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return builder.build();
    }

    private void initCuratorClient(RegistryCenterConfiguration config) {
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(config.getRetryIntervalMilliseconds() * config.getMaxRetries(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public String get(String key) {
        TreeCache cache = this.findTreeCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        ChildData resultInCache = cache.getCurrentData(key);
        if (null != resultInCache) {
            return null == resultInCache.getData() ? null : new String(resultInCache.getData(), Charsets.UTF_8);
        }
        return this.getDirectly(key);
    }

    private TreeCache findTreeCache(String key) {
        for (Map.Entry<String, TreeCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), Charsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            return result;
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(Charsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void update(String key, String value) {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.client.inTransaction().check().forPath(key)).and().setData().forPath(key, value.getBytes(Charsets.UTF_8))).and().commit();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(Charsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void watch(String key, final EventListener eventListener) {
        String path = key + "/";
        if (!this.caches.containsKey(path)) {
            this.addCacheData(key);
        }
        TreeCache cache = this.caches.get(path);
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws UnsupportedEncodingException {
                ChildData data = event.getData();
                if (null == data || null == data.getPath()) {
                    return;
                }
                eventListener.onChange(new DataChangedEvent(this.getEventType(event), data.getPath(), null == data.getData() ? null : new String(data.getData(), "UTF-8")));
            }

            private DataChangedEvent.Type getEventType(TreeCacheEvent event) {
                switch (event.getType()) {
                    case NODE_UPDATED: {
                        return DataChangedEvent.Type.UPDATED;
                    }
                    case NODE_REMOVED: {
                        return DataChangedEvent.Type.DELETED;
                    }
                }
                return DataChangedEvent.Type.IGNORED;
            }
        });
    }

    private void addCacheData(String cachePath) {
        TreeCache cache = new TreeCache(this.client, cachePath);
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    public void close() {
        for (Map.Entry<String, TreeCache> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

