/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.test.sql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.test.sql.SQLCase;
import io.shardingsphere.test.sql.SQLCaseType;
import io.shardingsphere.test.sql.SQLCases;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class SQLCasesLoader {
    private static final SQLCasesLoader INSTANCE = new SQLCasesLoader();
    protected Map<String, SQLCase> supportedSQLCaseMap = SQLCasesLoader.loadSQLCases("sql");
    protected Map<String, SQLCase> unsupportedSQLCaseMap = SQLCasesLoader.loadSQLCases("unsupported_sql");
    private final Map<String, SQLCase> parseErrorSQLCaseMap = SQLCasesLoader.loadSQLCases("parse_error_sql");

    protected SQLCasesLoader() {
    }

    public static SQLCasesLoader getInstance() {
        return INSTANCE;
    }

    public void switchSQLCase(String path) {
        this.supportedSQLCaseMap = SQLCasesLoader.loadSQLCases(path);
    }

    protected static Map<String, SQLCase> loadSQLCases(String path) {
        File file = new File(SQLCasesLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.isFile() ? SQLCasesLoader.loadSQLCasesFromJar(path, file) : SQLCasesLoader.loadSQLCasesFromTargetDirectory(path);
    }

    private static Map<String, SQLCase> loadSQLCasesFromJar(String path, File file) throws IOException, JAXBException {
        TreeMap<String, SQLCase> result = new TreeMap<String, SQLCase>();
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path + "/") || !name.endsWith(".xml")) continue;
                SQLCasesLoader.fillSQLMap(result, SQLCasesLoader.class.getClassLoader().getResourceAsStream(name));
            }
        }
        return result;
    }

    private static Map<String, SQLCase> loadSQLCasesFromTargetDirectory(String path) {
        TreeMap<String, SQLCase> result = new TreeMap<String, SQLCase>();
        URL url = SQLCasesLoader.class.getClassLoader().getResource(path);
        if (null == url) {
            return result;
        }
        File filePath = new File(url.getPath());
        if (!filePath.exists()) {
            return result;
        }
        File[] files = filePath.listFiles();
        if (null == files) {
            return result;
        }
        for (File each : files) {
            SQLCasesLoader.loadSQLCasesFromDirectory(result, each);
        }
        return result;
    }

    private static void loadSQLCasesFromDirectory(Map<String, SQLCase> sqlStatementMap, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (null == files) {
                return;
            }
            for (File each : files) {
                SQLCasesLoader.loadSQLCasesFromDirectory(sqlStatementMap, each);
            }
        } else {
            SQLCasesLoader.fillSQLMap(sqlStatementMap, new FileInputStream(file));
        }
    }

    private static void fillSQLMap(Map<String, SQLCase> sqlCaseMap, InputStream inputStream) throws JAXBException {
        SQLCases sqlCases = (SQLCases)JAXBContext.newInstance((Class[])new Class[]{SQLCases.class}).createUnmarshaller().unmarshal(inputStream);
        for (SQLCase each : sqlCases.getSqlCases()) {
            if (null == each.getDatabaseTypes()) {
                each.setDatabaseTypes(sqlCases.getDatabaseTypes());
            }
            if (null != sqlCases.getNamespace()) {
                each.setId(sqlCases.getNamespace() + "." + each.getId());
            }
            sqlCaseMap.put(each.getId(), each);
        }
    }

    public String getSupportedSQL(String sqlCaseId, SQLCaseType sqlCaseType, List<?> parameters) {
        return this.getSQL(this.supportedSQLCaseMap, sqlCaseId, sqlCaseType, parameters);
    }

    public String getUnsupportedSQL(String sqlCaseId, SQLCaseType sqlCaseType, List<?> parameters) {
        return this.getSQL(this.unsupportedSQLCaseMap, sqlCaseId, sqlCaseType, parameters);
    }

    public String getSQLParsingErrorSQL(String sqlCaseId, SQLCaseType sqlCaseType, List<?> parameters) {
        return this.getSQL(this.parseErrorSQLCaseMap, sqlCaseId, sqlCaseType, parameters);
    }

    private String getSQL(Map<String, SQLCase> sqlCaseMap, String sqlCaseId, SQLCaseType sqlCaseType, List<?> parameters) {
        switch (sqlCaseType) {
            case Literal: {
                return this.getLiteralSQL(this.getSQLFromMap(sqlCaseId, sqlCaseMap), parameters);
            }
            case Placeholder: {
                return this.getPlaceholderSQL(this.getSQLFromMap(sqlCaseId, sqlCaseMap));
            }
        }
        throw new UnsupportedOperationException(sqlCaseType.name());
    }

    private String getSQLFromMap(String id, Map<String, SQLCase> sqlCaseMap) {
        Preconditions.checkState((boolean)sqlCaseMap.containsKey(id), (Object)("Can't find SQL of id: " + id));
        SQLCase statement = sqlCaseMap.get(id);
        return statement.getValue();
    }

    private String getPlaceholderSQL(String sql) {
        return sql.replace("%%", "%").replace("'%'", "'%%'");
    }

    private String getLiteralSQL(String sql, List<?> parameters) {
        if (null == parameters || parameters.isEmpty()) {
            return sql;
        }
        return String.format(sql.replace("?", "%s"), parameters.toArray()).replace("%%", "%").replace("'%'", "'%%'");
    }

    public Collection<Object[]> getSupportedSQLTestParameters(Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType) {
        return this.getTestParameters(this.supportedSQLCaseMap, allDatabaseTypes, enumType);
    }

    public Collection<Object[]> getUnsupportedSQLTestParameters(Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType) {
        return this.getTestParameters(this.unsupportedSQLCaseMap, allDatabaseTypes, enumType);
    }

    public Collection<Object[]> getSQLParsingErrorTestParameters(Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType) {
        return this.getTestParameters(this.parseErrorSQLCaseMap, allDatabaseTypes, enumType);
    }

    private Collection<Object[]> getTestParameters(Map<String, SQLCase> sqlCaseMap, Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        for (SQLCase each : sqlCaseMap.values()) {
            result.addAll(this.getTestParameters(allDatabaseTypes, enumType, each));
        }
        return result;
    }

    private Collection<Object[]> getTestParameters(Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType, SQLCase sqlCase) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        for (SQLCaseType each : SQLCaseType.values()) {
            if (each == SQLCaseType.Placeholder && !Strings.isNullOrEmpty((String)sqlCase.getSqlType()) && !"dql".equals(sqlCase.getSqlType()) && !"dml".equals(sqlCase.getSqlType())) continue;
            result.addAll(SQLCasesLoader.getTestParameters(sqlCase, allDatabaseTypes, enumType, each));
        }
        return result;
    }

    private static Collection<Object[]> getTestParameters(SQLCase sqlCase, Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType, SQLCaseType sqlCaseType) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        for (Enum enum_ : SQLCasesLoader.getDatabaseTypes(sqlCase.getDatabaseTypes(), allDatabaseTypes, enumType)) {
            Object[] parameters = new Object[]{sqlCase.getId(), enum_, sqlCaseType};
            result.add(parameters);
        }
        return result;
    }

    private static Collection<? extends Enum> getDatabaseTypes(String databaseTypes, Collection<? extends Enum> allDatabaseTypes, Class<? extends Enum> enumType) {
        if (Strings.isNullOrEmpty((String)databaseTypes)) {
            return allDatabaseTypes;
        }
        HashSet<Enum> result = new HashSet<Enum>(allDatabaseTypes.size());
        for (String each : databaseTypes.split(",")) {
            result.add(Enum.valueOf(enumType, each));
        }
        return result;
    }

    public int countAllSupportedSQLCases() {
        return this.supportedSQLCaseMap.size();
    }
}

