/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert.swap;

import io.shardingsphere.transaction.xa.convert.swap.DataSourceSwapper;
import io.shardingsphere.transaction.xa.convert.swap.DefaultDataSourceSwapper;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceSwapperRegistry {
    private static final Logger log = LoggerFactory.getLogger(DataSourceSwapperRegistry.class);
    private static final Map<String, DataSourceSwapper> SWAPPERS = new HashMap<String, DataSourceSwapper>();

    private static void loadSwapper(DataSourceSwapper swapper) {
        for (String each : swapper.getDataSourceClassNames()) {
            if (SWAPPERS.containsKey(each)) {
                log.warn("Find more than one {} data source swapper implementation class, use `{}` now", (Object)each, (Object)SWAPPERS.get(each).getClass().getName());
                continue;
            }
            SWAPPERS.put(each, swapper);
        }
    }

    public static DataSourceSwapper getSwapper(Class<? extends DataSource> dataSourceClass) {
        return SWAPPERS.containsKey(dataSourceClass.getName()) ? SWAPPERS.get(dataSourceClass.getName()) : new DefaultDataSourceSwapper();
    }

    private DataSourceSwapperRegistry() {
    }

    static {
        for (DataSourceSwapper each : ServiceLoader.load(DataSourceSwapper.class)) {
            DataSourceSwapperRegistry.loadSwapper(each);
        }
    }
}

