/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.manager;

import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyUtils;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.transaction.xa.convert.datasource.XAPropertiesFactory;
import io.shardingsphere.transaction.xa.manager.XADataSourceWrapper;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public final class AtomikosDataSourceBeanWrapper
implements XADataSourceWrapper {
    private final AtomikosDataSourceBean delegate = new AtomikosDataSourceBean();

    @Override
    public DataSource wrap(DatabaseType databaseType, XADataSource xaDataSource, String dataSourceName, DataSourceParameter parameter) throws PropertyException {
        this.setAtomikosDatasourceBean(databaseType, xaDataSource, dataSourceName, parameter);
        return this.delegate;
    }

    private void setAtomikosDatasourceBean(DatabaseType databaseType, XADataSource xaDataSource, String dataSourceName, DataSourceParameter parameter) throws PropertyException {
        this.setPoolProperties(parameter);
        this.setXAProperties(databaseType, xaDataSource, dataSourceName, parameter);
    }

    private void setPoolProperties(DataSourceParameter parameter) {
        this.delegate.setMaintenanceInterval((int)(parameter.getMaintenanceIntervalMilliseconds() / 1000L));
        this.delegate.setMinPoolSize(parameter.getMinPoolSize() < 0 ? 0 : parameter.getMinPoolSize());
        this.delegate.setMaxPoolSize(parameter.getMaxPoolSize());
        this.delegate.setBorrowConnectionTimeout((int)parameter.getConnectionTimeoutMilliseconds() / 1000);
        this.delegate.setReapTimeout((int)parameter.getMaxLifetimeMilliseconds() / 1000);
        this.delegate.setMaxIdleTime((int)parameter.getIdleTimeoutMilliseconds() / 1000);
    }

    private void setXAProperties(DatabaseType databaseType, XADataSource xaDataSource, String dataSourceName, DataSourceParameter dataSourceParameter) throws PropertyException {
        this.delegate.setXaDataSourceClassName(xaDataSource.getClass().getName());
        this.delegate.setUniqueResourceName(dataSourceName);
        Properties xaProperties = XAPropertiesFactory.createXAProperties(databaseType).build(dataSourceParameter);
        PropertyUtils.setProperties((Object)xaDataSource, (Map)xaProperties);
        this.delegate.setXaProperties(xaProperties);
        this.delegate.setXaDataSource(xaDataSource);
    }
}

