/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.manager;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.spi.NewInstanceServiceLoader;
import io.shardingsphere.transaction.spi.xa.XATransactionManager;
import io.shardingsphere.transaction.xa.manager.AtomikosTransactionManager;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XATransactionManagerSPILoader {
    private static final Logger log = LoggerFactory.getLogger(XATransactionManagerSPILoader.class);
    private static final XATransactionManagerSPILoader INSTANCE = new XATransactionManagerSPILoader();
    private final Collection<XATransactionManager> xaTransactionManagers = NewInstanceServiceLoader.load(XATransactionManager.class);
    private final XATransactionManager transactionManager = this.load();

    private XATransactionManagerSPILoader() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (null != XATransactionManagerSPILoader.this.transactionManager) {
                    XATransactionManagerSPILoader.this.transactionManager.destroy();
                }
            }
        }));
    }

    private XATransactionManager load() {
        try {
            if (this.xaTransactionManagers.size() > 1) {
                log.warn("There are more than one transaction mangers existing, chosen first one by default.");
            }
            if (this.xaTransactionManagers.isEmpty()) {
                return new AtomikosTransactionManager();
            }
            return this.xaTransactionManagers.iterator().next();
        }
        catch (Exception ex) {
            throw new ShardingException("Can not initialize the xaTransaction manager failed with " + ex, new Object[0]);
        }
    }

    public static XATransactionManagerSPILoader getInstance() {
        return INSTANCE;
    }

    public Collection<XATransactionManager> getXaTransactionManagers() {
        return this.xaTransactionManagers;
    }

    public XATransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

