/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.util;

import io.shiftleft.js2cpg.util.JmxCpuMetric;
import io.shiftleft.js2cpg.util.JmxGCMetric;
import io.shiftleft.js2cpg.util.JmxMemoryMetric;
import java.io.Serializable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Q3Qa\u0002\u0005\u0002\u0002EAQ\u0001\u0007\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0012uAqA\r\u0001\u0012\u0002\u0013E1\u0007C\u0003?\u0001\u0011\u0005q\bC\u0003G\u0001\u0011\u0005q\tC\u0003N\u0001\u0011\u0005aJA\u0005K[b\u001cE.[3oi*\u0011\u0011BC\u0001\u0005kRLGN\u0003\u0002\f\u0019\u00051!n\u001d\u001ada\u001eT!!\u0004\b\u0002\u0013MD\u0017N\u001a;mK\u001a$(\"A\b\u0002\u0005%|7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\t\u0003\u0011Ig.\u001b;\u0015\u0007yY\u0003\u0007E\u0002\u0014?\u0005J!\u0001\t\u000b\u0003\r=\u0003H/[8o!\t\u0011\u0013&D\u0001$\u0015\t!S%\u0001\u0004sK6|G/\u001a\u0006\u0003M\u001d\n!\"\\1oC\u001e,W.\u001a8u\u0015\u0005A\u0013!\u00026bm\u0006D\u0018B\u0001\u0016$\u00051QU\nW\"p]:,7\r^8s\u0011\u0015a#\u00011\u0001.\u0003\u0011\u0001xN\u001d;\u0011\u0005Mq\u0013BA\u0018\u0015\u0005\rIe\u000e\u001e\u0005\bc\t\u0001\n\u00111\u0001.\u0003\u001d\u0011X\r\u001e:jKN\fa\"\u001b8ji\u0012\"WMZ1vYR$#'F\u00015U\tiSgK\u00017!\t9D(D\u00019\u0015\tI$(A\u0005v]\u000eDWmY6fI*\u00111\bF\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u001f9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\r[\u0016lwN]=NKR\u0014\u0018n\u0019\u000b\u0003\u0001\u0012\u00032aE\u0010B!\tY\")\u0003\u0002D\u0011\ty!*\u001c=NK6|'/_'fiJL7\rC\u0003F\t\u0001\u0007a$\u0001\u0003k[b\u001c\u0017!C2qk6+GO]5d)\tAE\nE\u0002\u0014?%\u0003\"a\u0007&\n\u0005-C!\u0001\u0004&nq\u000e\u0003X/T3ue&\u001c\u0007\"B#\u0006\u0001\u0004q\u0012\u0001C4d\u001b\u0016$(/[2\u0015\u0005=\u001b\u0006cA\n !B\u00111$U\u0005\u0003%\"\u00111BS7y\u000f\u000ekU\r\u001e:jG\")QI\u0002a\u0001=\u0001")
public abstract class JmxClient {
    public Option<JMXConnector> init(int port, int retries) {
        JMXServiceURL url = new JMXServiceURL(new StringBuilder(47).append("service:jmx:rmi:///jndi/rmi://localhost:").append(port).append("/jmxrmi").toString());
        return this.withRetries$1(url, retries);
    }

    public int init$default$2() {
        return 30;
    }

    public Option<JmxMemoryMetric> memoryMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                Object memoryMbean = jmxc.getMBeanServerConnection().getAttribute(new ObjectName("java.lang:type=Memory"), "HeapMemoryUsage");
                CompositeData cd = (CompositeData)memoryMbean;
                return new Some((Object)new JmxMemoryMetric(BoxesRunTime.unboxToLong((Object)cd.get("used")), BoxesRunTime.unboxToLong((Object)cd.get("committed"))));
            });
        }
        catch (Throwable throwable) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JmxCpuMetric> cpuMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                MBeanServerConnection connection = jmxc.getMBeanServerConnection();
                Object osMbean = connection.getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "ProcessCpuTime");
                long threads = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=Threading"), "ThreadCount"));
                return new Some((Object)new JmxCpuMetric(osMbean, threads));
            });
        }
        catch (Throwable throwable) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JmxGCMetric> gcMetric(Option<JMXConnector> jmxc2) {
        Option option;
        try {
            option = jmxc2.flatMap((Function1 & Serializable)jmxc -> {
                MBeanServerConnection connection = jmxc.getMBeanServerConnection();
                long gcParCollectionCount = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ParNew"), "CollectionCount"));
                long gcParCollectionTime = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ParNew"), "CollectionTime"));
                long gcConCollectionCount = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep"), "CollectionCount"));
                long gcConCollectionTime = BoxesRunTime.unboxToLong((Object)connection.getAttribute(new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep"), "CollectionTime"));
                return new Some((Object)new JmxGCMetric(gcParCollectionCount, gcParCollectionTime, gcConCollectionCount, gcConCollectionTime));
            });
        }
        catch (Throwable throwable) {
            option = None$.MODULE$;
        }
        return option;
    }

    private final Option withRetries$1(JMXServiceURL url, int retriesLeft) {
        None$ none$;
        while (true) {
            try {
                Some jmxc = new Some((Object)JMXConnectorFactory.connect(url, null));
                jmxc.foreach((Function1 & Serializable)x$1 -> {
                    x$1.connect();
                    return BoxedUnit.UNIT;
                });
                none$ = jmxc;
            }
            catch (Throwable throwable) {
                if (retriesLeft > 0) {
                    Thread.sleep(100L);
                    --retriesLeft;
                    continue;
                }
                none$ = None$.MODULE$;
            }
            break;
        }
        return none$;
    }
}

