/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.codegen;

import java.io.Serializable;
import overflowdb.algorithm.LowestCommonAncestors$;
import overflowdb.codegen.DefaultNodeTypes$;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.AnyNodeType;
import overflowdb.schema.ContainedNode;
import overflowdb.schema.EdgeType;
import overflowdb.schema.EdgeType$Cardinality$List$;
import overflowdb.schema.EdgeType$Cardinality$One$;
import overflowdb.schema.EdgeType$Cardinality$ZeroOrOne$;
import overflowdb.schema.NeighborInfoForNode;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.Property;
import overflowdb.schema.Property$Cardinality$List$;
import overflowdb.schema.Property$Cardinality$ZeroOrOne$;
import overflowdb.schema.Property$ValueType$Boolean$;
import overflowdb.schema.Property$ValueType$Byte$;
import overflowdb.schema.Property$ValueType$Char$;
import overflowdb.schema.Property$ValueType$Double$;
import overflowdb.schema.Property$ValueType$Float$;
import overflowdb.schema.Property$ValueType$Int$;
import overflowdb.schema.Property$ValueType$List$;
import overflowdb.schema.Property$ValueType$Long$;
import overflowdb.schema.Property$ValueType$NodeRef$;
import overflowdb.schema.Property$ValueType$Short$;
import overflowdb.schema.Property$ValueType$String$;
import overflowdb.schema.Property$ValueType$Unknown$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Helpers$ {
    public static Helpers$ MODULE$;
    private final String propertyErrorRegisterImpl;
    private final Set<String> scalaReservedKeywords;
    private final char quotes;

    static {
        new Helpers$();
    }

    public Iterable<String> quoted(Iterable<String> strings) {
        return (Iterable)strings.map((Function1 & Serializable & scala.Serializable)string -> MODULE$.quote((String)string), Iterable$.MODULE$.canBuildFrom());
    }

    public String quote(String string) {
        return new StringBuilder(2).append("\"").append(string).append("\"").toString();
    }

    public Option<String> stringToOption(String s) {
        String string = s.trim();
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        return new Some((Object)string);
    }

    public <A> String typeFor(Property<A> property) {
        boolean isMandatory = property.isMandatory();
        Property.ValueType<A> valueType = property.valueType();
        if (Property$ValueType$Boolean$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Boolean";
            }
            return "java.lang.Boolean";
        }
        if (Property$ValueType$String$.MODULE$.equals(valueType)) {
            return "String";
        }
        if (Property$ValueType$Byte$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Byte";
            }
            return "java.lang.Byte";
        }
        if (Property$ValueType$Short$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Short";
            }
            return "java.lang.Short";
        }
        if (Property$ValueType$Int$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "scala.Int";
            }
            return "Integer";
        }
        if (Property$ValueType$Long$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Long";
            }
            return "java.lang.Long";
        }
        if (Property$ValueType$Float$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Float";
            }
            return "java.lang.Float";
        }
        if (Property$ValueType$Double$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "Double";
            }
            return "java.lang.Double";
        }
        if (Property$ValueType$Char$.MODULE$.equals(valueType)) {
            if (isMandatory) {
                return "scala.Char";
            }
            return "Character";
        }
        if (Property$ValueType$List$.MODULE$.equals(valueType)) {
            return "Seq[_]";
        }
        if (Property$ValueType$NodeRef$.MODULE$.equals(valueType)) {
            return "overflowdb.NodeRef[_]";
        }
        if (Property$ValueType$Unknown$.MODULE$.equals(valueType)) {
            return "java.lang.Object";
        }
        throw new MatchError(valueType);
    }

    public String accessorName(NeighborInfoForNode neighborInfoForNode) {
        return (String)neighborInfoForNode.customStepName().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String neighborNodeName = neighborInfoForNode.neighborNode().name();
            String edgeName = neighborInfoForNode.edge().className();
            String direction = neighborInfoForNode.direction().toString();
            return new StringBuilder(4).append("_").append(MODULE$.camelCase(neighborNodeName)).append("Via").append(edgeName).append(MODULE$.camelCaseCaps(direction)).toString();
        });
    }

    public String docAnnotationMaybe(Option<String> customStepDoc) {
        Option option = customStepDoc.map((Function1 & Serializable & scala.Serializable)src -> MODULE$.escapeJava((String)src));
        if (option instanceof Some) {
            Some some = (Some)option;
            String doc = (String)some.value();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("/** ").append(doc).append(" */\n           |@overflowdb.traversal.help.Doc(info = \"\"\"").append(doc).append("\"\"\")").toString())).stripMargin();
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError((Object)option);
    }

    public String escapeJava(String src) {
        return src.replace("\"", "\\\"").replace("/*", "\\/\\*").replace("*/", "\\*\\/");
    }

    public boolean isNodeBaseTrait(Seq<NodeBaseType> baseTraits, String nodeName) {
        String string = nodeName;
        String string2 = DefaultNodeTypes$.MODULE$.AbstractNodeName();
        return !(string == null ? string2 != null : !string.equals(string2)) || ((SeqLike)baseTraits.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).contains((Object)nodeName);
    }

    public String camelCaseCaps(String snakeCase) {
        return new StringOps(Predef$.MODULE$.augmentString(this.camelCase(snakeCase))).capitalize();
    }

    public String camelCase(String snakeCase) {
        Nil$ nil$;
        String corrected = snakeCase.startsWith("_") ? (String)new StringOps(Predef$.MODULE$.augmentString(snakeCase)).drop(1) : snakeCase;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corrected.split("_"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String head = (String)colon2.head();
            List tail = colon2.tl$access$1();
            String string = head;
            nil$ = ((List)tail.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString(x$3)).capitalize(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
        } else if (Nil$.MODULE$.equals(list)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)list);
        }
        Nil$ elements = nil$;
        return elements.mkString();
    }

    public String snakeCase(String camelCase) {
        return this.go$1((List)Nil$.MODULE$, new StringOps(Predef$.MODULE$.augmentString(camelCase)).toList()).mkString().toLowerCase();
    }

    public String singularize(String str) {
        if (str.endsWith("ies")) {
            return new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(str)).dropRight(3)).append("y").toString();
        }
        return (String)new StringOps(Predef$.MODULE$.augmentString(str)).dropRight(1);
    }

    public <A> String getCompleteType(Property<?> property) {
        return this.getCompleteType(property.cardinality(), this.typeFor(property));
    }

    public String typeFor(ContainedNode containedNode) {
        AbstractNodeType abstractNodeType = containedNode.nodeType();
        if (abstractNodeType instanceof AnyNodeType) {
            return "AbstractNode";
        }
        String className = containedNode.nodeType().className();
        if (DefaultNodeTypes$.MODULE$.AllClassNames().contains((Object)className)) {
            return className;
        }
        return new StringBuilder(4).append(className).append("Base").toString();
    }

    public String getCompleteType(ContainedNode containedNode) {
        return this.getCompleteType(containedNode.cardinality(), this.typeFor(containedNode));
    }

    public String getCompleteType(Property.Cardinality cardinality, String valueType) {
        Property.Cardinality cardinality2 = cardinality;
        if (cardinality2 instanceof Property.Cardinality.One) {
            return valueType;
        }
        if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            return new StringBuilder(8).append("Option[").append(valueType).append("]").toString();
        }
        if (Property$Cardinality$List$.MODULE$.equals(cardinality2)) {
            return new StringBuilder(12).append("IndexedSeq[").append(valueType).append("]").toString();
        }
        throw new MatchError((Object)cardinality2);
    }

    public String propertyKeyDef(String name, String baseType, Property.Cardinality cardinality) {
        String string;
        Property.Cardinality cardinality2 = cardinality;
        if (cardinality2 instanceof Property.Cardinality.One) {
            string = baseType;
        } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            string = baseType;
        } else if (Property$Cardinality$List$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(12).append("IndexedSeq[").append(baseType).append("]").toString();
        } else {
            throw new MatchError((Object)cardinality2);
        }
        String completeType = string;
        return new StringBuilder(40).append("val ").append(this.camelCaseCaps(name)).append(" = new overflowdb.PropertyKey[").append(completeType).append("](\"").append(name).append("\") ").toString();
    }

    public <A> String defaultValueImpl(Property.Default<A> default_) {
        boolean bl = false;
        float f = BoxesRunTime.unboxToFloat(null);
        boolean bl2 = false;
        double d = BoxesRunTime.unboxToDouble(null);
        A a = default_.value();
        if (a instanceof String) {
            String string = (String)a;
            return new StringBuilder(0).append(this.quotes()).append(string).append(this.quotes()).toString();
        }
        if (a instanceof Character) {
            char c = BoxesRunTime.unboxToChar(a);
            return new StringBuilder(2).append("'").append(c).append("'").toString();
        }
        if (a instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(a);
            return new StringBuilder(6).append(by).append(": Byte").toString();
        }
        if (a instanceof Short) {
            short s = BoxesRunTime.unboxToShort(a);
            return new StringBuilder(7).append(s).append(": Short").toString();
        }
        if (a instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(a);
            return new StringBuilder(5).append(n).append(": Int").toString();
        }
        if (a instanceof Long) {
            long l = BoxesRunTime.unboxToLong(a);
            return new StringBuilder(6).append(l).append(": Long").toString();
        }
        if (a instanceof Float) {
            bl = true;
            f = BoxesRunTime.unboxToFloat(a);
            if (Float.isNaN(f)) {
                return "Float.NaN";
            }
        }
        if (bl) {
            return new StringBuilder(1).append(f).append("f").toString();
        }
        if (a instanceof Double) {
            bl2 = true;
            d = BoxesRunTime.unboxToDouble(a);
            if (Double.isNaN(d)) {
                return "Double.NaN";
            }
        }
        if (bl2) {
            return new StringBuilder(1).append(d).append("d").toString();
        }
        return String.valueOf(a);
    }

    public <A> String defaultValueCheckImpl(String memberName, Property.Default<A> default_) {
        double d;
        float f;
        String defaultValueSrc = this.defaultValueImpl(default_);
        A a = default_.value();
        if (a instanceof Float && Float.isNaN(f = BoxesRunTime.unboxToFloat(a))) {
            return new StringBuilder(6).append(memberName).append(".isNaN").toString();
        }
        if (a instanceof Double && Double.isNaN(d = BoxesRunTime.unboxToDouble(a))) {
            return new StringBuilder(6).append(memberName).append(".isNaN").toString();
        }
        return new StringBuilder(6).append("(").append(defaultValueSrc).append(") == ").append(memberName).toString();
    }

    public String propertyDefaultValueImpl(String propertyDefaultsPath, Seq<Property<?>> properties) {
        String propertyDefaultValueCases = ((TraversableOnce)properties.collect((PartialFunction)new scala.Serializable(propertyDefaultsPath){
            public static final long serialVersionUID = 0L;
            private final String propertyDefaultsPath$1;

            public final <A1 extends Property<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.hasDefault()) {
                    return (B1)new StringBuilder(12).append("case \"").append(A1.name()).append("\" => ").append(this.propertyDefaultsPath$1).append(".").append(A1.className()).toString();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Property<?> x1) {
                Property<?> property = x1;
                return property.hasDefault();
            }
            {
                this.propertyDefaultsPath$1 = propertyDefaultsPath$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("override def propertyDefaultValue(propertyKey: String) =\n       |  propertyKey match {\n       |    ").append(propertyDefaultValueCases).append("\n       |    case _ => super.propertyDefaultValue(propertyKey)\n       |}\n       |").toString())).stripMargin();
    }

    public String propertyDefaultCases(Seq<Property<?>> properties) {
        return ((TraversableOnce)properties.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Property<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.hasDefault()) {
                    return (B1)new StringBuilder(7).append("val ").append(A1.className()).append(" = ").append(Helpers$.MODULE$.defaultValueImpl((Property.Default)A1.default().get())).toString();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Property<?> x1) {
                Property<?> property = x1;
                return property.hasDefault();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(new StringBuilder(5).append(System.lineSeparator()).append("|    ").toString());
    }

    public String propertyAccessors(Seq<Property<?>> properties) {
        return ((TraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)property -> {
            String camelCaseName = MODULE$.camelCase(property.name());
            String tpe = MODULE$.getCompleteType((Property<?>)property);
            return new StringBuilder(6).append("def ").append(camelCaseName).append(": ").append(tpe).toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
    }

    public String propertyErrorRegisterImpl() {
        return this.propertyErrorRegisterImpl;
    }

    public Set<String> scalaReservedKeywords() {
        return this.scalaReservedKeywords;
    }

    public String escapeIfKeyword(String value) {
        if (this.scalaReservedKeywords().contains((Object)value)) {
            return new StringBuilder(2).append("`").append(value).append("`").toString();
        }
        return value;
    }

    public String fullScalaType(AbstractNodeType neighborNode, EdgeType.Cardinality cardinality) {
        String neighborNodeClass = neighborNode.className();
        EdgeType.Cardinality cardinality2 = cardinality;
        if (EdgeType$Cardinality$List$.MODULE$.equals(cardinality2)) {
            return new StringBuilder(32).append("overflowdb.traversal.Traversal[").append(neighborNodeClass).append("]").toString();
        }
        if (EdgeType$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            return new StringBuilder(8).append("Option[").append(neighborNodeClass).append("]").toString();
        }
        if (EdgeType$Cardinality$One$.MODULE$.equals(cardinality2)) {
            return String.valueOf(neighborNodeClass);
        }
        throw new MatchError((Object)cardinality2);
    }

    public Option<AbstractNodeType> deriveCommonRootType(Set<AbstractNodeType> neighborNodeInfos) {
        return this.lowestCommonAncestor(neighborNodeInfos).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.findSharedRoot(neighborNodeInfos));
    }

    public Option<AbstractNodeType> lowestCommonAncestor(Set<AbstractNodeType> nodes) {
        return ((TraversableLike)LowestCommonAncestors$.MODULE$.apply(nodes, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.extendzRecursively().toSet()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), (Ordering)Ordering.String$.MODULE$)).headOption();
    }

    public Option<AbstractNodeType> findSharedRoot(Set<AbstractNodeType> nodeTypes) {
        if (nodeTypes.size() == 1) {
            return new Some(nodeTypes.head());
        }
        if (nodeTypes.size() > 1) {
            Seq sorted = (Seq)nodeTypes.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7.className(), (Ordering)Ordering.String$.MODULE$);
            Tuple2 tuple2 = new Tuple2(sorted.head(), sorted.tail());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AbstractNodeType first = (AbstractNodeType)tuple2._1();
            Seq otherNodes = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)first, (Object)otherNodes);
            AbstractNodeType first2 = (AbstractNodeType)tuple22._1();
            Seq otherNodes2 = (Seq)tuple22._2();
            return this.completeTypeHierarchy(first2).find((Function1 & Serializable & scala.Serializable)candidate -> BoxesRunTime.boxToBoolean((boolean)otherNodes2.forall((Function1 & Serializable & scala.Serializable)otherNode -> BoxesRunTime.boxToBoolean((boolean)Helpers$.$anonfun$findSharedRoot$3(candidate, otherNode)))));
        }
        return None$.MODULE$;
    }

    public Seq<AbstractNodeType> completeTypeHierarchy(AbstractNodeType node) {
        AbstractNodeType abstractNodeType = node;
        return (Seq)node.extendzRecursively().$plus$colon((Object)abstractNodeType, Seq$.MODULE$.canBuildFrom());
    }

    public char quotes() {
        return this.quotes;
    }

    private final List go$1(List accDone, List acc) {
        List list;
        while (true) {
            List tail;
            boolean bl = false;
            .colon.colon colon2 = null;
            list = acc;
            if (Nil$.MODULE$.equals(list)) {
                return accDone;
            }
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                char a = BoxesRunTime.unboxToChar((Object)colon2.head());
                List list2 = colon2.tl$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    char b = BoxesRunTime.unboxToChar((Object)colon3.head());
                    List list3 = colon3.tl$access$1();
                    if (list3 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list3;
                        char c = BoxesRunTime.unboxToChar((Object)colon4.head());
                        List tail2 = colon4.tl$access$1();
                        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(a)) && RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(b)) && RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(c))) {
                            acc = tail2;
                            accDone = (List)accDone.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{a, '_', b, c})), List$.MODULE$.canBuildFrom());
                            continue;
                        }
                    }
                }
            }
            if (bl) {
                char a = BoxesRunTime.unboxToChar((Object)colon2.head());
                List list4 = colon2.tl$access$1();
                if (list4 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list4;
                    char b = BoxesRunTime.unboxToChar((Object)colon5.head());
                    List tail3 = colon5.tl$access$1();
                    if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(a)) && RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(b))) {
                        acc = tail3;
                        accDone = (List)accDone.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{a, '_', b})), List$.MODULE$.canBuildFrom());
                        continue;
                    }
                }
            }
            if (!bl) break;
            char a = BoxesRunTime.unboxToChar((Object)colon2.head());
            acc = tail = colon2.tl$access$1();
            accDone = (List)accDone.$colon$plus((Object)BoxesRunTime.boxToCharacter((char)a), List$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)list);
    }

    public static final /* synthetic */ boolean $anonfun$findSharedRoot$3(AbstractNodeType candidate$1, AbstractNodeType otherNode) {
        return MODULE$.completeTypeHierarchy(otherNode).contains((Object)candidate$1);
    }

    private Helpers$() {
        MODULE$ = this;
        this.propertyErrorRegisterImpl = new StringOps(Predef$.MODULE$.augmentString("object PropertyErrorRegister {\n       |  private var errorMap = Set[(Class[_], String)]()\n       |  private val logger = org.slf4j.LoggerFactory.getLogger(getClass)\n       |\n       |  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {\n       |    if (!errorMap.contains((clazz, propertyName))) {\n       |      logger.warn(\"Property \" + propertyName + \" is deprecated for \" + clazz.getName + \".\")\n       |      errorMap += ((clazz, propertyName))\n       |    }\n       |  }\n       |}\n       |")).stripMargin();
        this.scalaReservedKeywords = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abstract", ">:", "if", ".", "catch", "protected", "final", "super", "while", "true", "val", "do", "throw", "<-", "package", "_", "macro", "@", "object", "false", "this", "then", "var", "trait", "with", "def", "else", "class", "type", "#", "lazy", "null", "=", "<:", "override", "=>", "private", "sealed", "finally", "new", "implicit", "extends", "for", "return", "case", "import", "forSome", ":", "yield", "try", "match", "<%"}));
        this.quotes = (char)34;
    }
}

