/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Config;
import overflowdb.EdgeFactory;
import overflowdb.Graph;
import overflowdb.NodeFactory;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.ExporterMain;
import overflowdb.formats.dot.DotExporter$;
import overflowdb.formats.graphml.GraphMLExporter$;
import overflowdb.formats.graphson.GraphSONExporter$;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter$;
import overflowdb.formats.package$Format$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ExporterMain$ {
    public static final ExporterMain$ MODULE$ = new ExporterMain$();
    private static Logger logger;
    private static OParserBuilder<ExporterMain.Config> builder;
    private static OParser<BoxedUnit, ExporterMain.Config> parser;
    private static volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        ExporterMain$ exporterMain$ = this;
        synchronized (exporterMain$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                logger = LoggerFactory.getLogger(this.getClass());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return logger;
    }

    public Logger logger() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Function1<String[], BoxedUnit> apply(scala.collection.immutable.Seq<NodeFactory<?>> nodeFactories, scala.collection.immutable.Seq<EdgeFactory<?>> edgeFactories) {
        return (Function1 & Serializable)args -> {
            ExporterMain$.$anonfun$apply$1(nodeFactories, edgeFactories, args);
            return BoxedUnit.UNIT;
        };
    }

    private OParserBuilder<ExporterMain.Config> builder$lzycompute() {
        ExporterMain$ exporterMain$ = this;
        synchronized (exporterMain$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                builder = OParser$.MODULE$.builder();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return builder;
    }

    private OParserBuilder<ExporterMain.Config> builder() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.builder$lzycompute();
        }
        return builder;
    }

    private OParser<BoxedUnit, ExporterMain.Config> parser$lzycompute() {
        ExporterMain$ exporterMain$ = this;
        synchronized (exporterMain$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                parser = OParser$.MODULE$.sequence(this.builder().programName("odb-export"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{this.builder().help("help").text("prints this usage text"), this.builder().opt('f', "format", Read$.MODULE$.stringRead()).required().action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$1 = (Enumeration.Value)package$Format$.MODULE$.byNameLowercase().apply(x);
                    Path x$2 = c.copy$default$1();
                    Path x$3 = c.copy$default$3();
                    return c.copy(x$2, x$1, x$3);
                }).text(new StringBuilder(24).append("export format, one of [").append(package$Format$.MODULE$.valuesAsStringLowercase().mkString("|")).append("]").toString()), this.builder().opt('o', "out", Read$.MODULE$.fileRead()).required().action((Function2 & Serializable)(x, c) -> {
                    Path x$4 = x.toPath();
                    Path x$5 = c.copy$default$1();
                    Enumeration.Value x$6 = c.copy$default$2();
                    return c.copy(x$5, x$6, x$4);
                }).text("output file or directory - must exist and be writable"), this.builder().arg("odbBinaryFile", Read$.MODULE$.fileRead()).required().action((Function2 & Serializable)(x, c) -> c.copy(x.toPath(), c.copy$default$2(), c.copy$default$3())).text("input overflowdb graph file - must exist and be readable")}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return parser;
    }

    private OParser<BoxedUnit, ExporterMain.Config> parser() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.parser$lzycompute();
        }
        return parser;
    }

    public static final /* synthetic */ void $anonfun$apply$4(String x$1) {
        MODULE$.logger().info(x$1);
    }

    public static final /* synthetic */ void $anonfun$apply$2(scala.collection.immutable.Seq nodeFactories$1, scala.collection.immutable.Seq edgeFactories$1, ExporterMain.Config x0$1) {
        ExporterMain.Config config = x0$1;
        if (config != null) {
            Exporter exporter;
            Path path;
            Path inputFile = config.inputFile();
            Enumeration.Value format = config.format();
            Path outputFile = config.outputFile();
            if (Files.notExists(inputFile, new LinkOption[0])) {
                throw new AssertionError((Object)new StringBuilder(32).append("given input file ").append(inputFile).append(" does not exist").toString());
            }
            if (Files.exists(outputFile, new LinkOption[0])) {
                if (Files.isRegularFile(outputFile, new LinkOption[0])) {
                    throw new AssertionError((Object)new StringBuilder(50).append("output file ").append(outputFile).append(" already exists and is not a directory").toString());
                }
                path = BoxedUnit.UNIT;
            } else {
                path = Files.createDirectories(outputFile, new FileAttribute[0]);
            }
            Enumeration.Value value = format;
            Enumeration.Value value2 = package$Format$.MODULE$.Neo4jCsv();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                exporter = Neo4jCsvExporter$.MODULE$;
            } else {
                Enumeration.Value value4 = package$Format$.MODULE$.GraphML();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    exporter = GraphMLExporter$.MODULE$;
                } else {
                    Enumeration.Value value6 = package$Format$.MODULE$.GraphSON();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        exporter = GraphSONExporter$.MODULE$;
                    } else {
                        Enumeration.Value value8 = package$Format$.MODULE$.Dot();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            exporter = DotExporter$.MODULE$;
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            Neo4jCsvExporter$ exporter2 = exporter;
            Config odbConfig = Config.withoutOverflow().withStorageLocation(inputFile);
            MODULE$.logger().info(new StringBuilder(55).append("starting export of graph in ").append(inputFile).append(" to storagePath=").append(outputFile).append(" in format=").append(format).toString());
            ExportResult exportResult = (ExportResult)Using$.MODULE$.resource((Object)Graph.open((Config)odbConfig, (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)nodeFactories$1).asJava(), (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)edgeFactories$1).asJava()), (Function1 & Serializable)graph -> exporter2.runExport((Graph)graph, outputFile), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            if (exportResult == null) {
                throw new MatchError((Object)exportResult);
            }
            int nodeCount = exportResult.nodeCount();
            int edgeCount = exportResult.edgeCount();
            scala.collection.immutable.Seq<Path> files = exportResult.files();
            Option<String> additionalInfo = exportResult.additionalInfo();
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)nodeCount), (Object)BoxesRunTime.boxToInteger((int)edgeCount), files, additionalInfo);
            int nodeCount2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int edgeCount2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            scala.collection.immutable.Seq files2 = (scala.collection.immutable.Seq)tuple4._3();
            Option additionalInfo2 = (Option)tuple4._4();
            MODULE$.logger().info(new StringBuilder(55).append("export completed successfully: ").append(nodeCount2).append(" nodes, ").append(edgeCount2).append(" edges in ").append(files2.size()).append(" files").toString());
            additionalInfo2.foreach((Function1 & Serializable)x$1 -> {
                ExporterMain$.$anonfun$apply$4(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)config);
    }

    public static final /* synthetic */ void $anonfun$apply$1(scala.collection.immutable.Seq nodeFactories$1, scala.collection.immutable.Seq edgeFactories$1, String[] args) {
        OParser$.MODULE$.parse(MODULE$.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ExporterMain.Config(Paths.get("/dev/null", new String[0]), null, Paths.get("/dev/null", new String[0]))).map((Function1 & Serializable)x0$1 -> {
            ExporterMain$.$anonfun$apply$2(nodeFactories$1, edgeFactories$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private ExporterMain$() {
    }
}

