/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Config;
import overflowdb.EdgeFactory;
import overflowdb.Graph;
import overflowdb.NodeFactory;
import overflowdb.formats.Importer;
import overflowdb.formats.ImporterMain;
import overflowdb.formats.graphml.GraphMLImporter$;
import overflowdb.formats.graphson.GraphSONImporter$;
import overflowdb.formats.neo4jcsv.Neo4jCsvImporter$;
import overflowdb.formats.package$Format$;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ImporterMain$
implements App {
    public static final ImporterMain$ MODULE$ = new ImporterMain$();
    private static Logger logger;
    private static OParserBuilder<ImporterMain.Config> builder;
    private static OParser<BoxedUnit, ImporterMain.Config> parser;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private static volatile byte bitmap$0;

    static {
        App.$init$((App)MODULE$);
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body) {
        App.delayedInit$((App)this, body);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    private Logger logger$lzycompute() {
        ImporterMain$ importerMain$ = this;
        synchronized (importerMain$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                logger = LoggerFactory.getLogger(this.getClass());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return logger;
    }

    public Logger logger() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Function1<String[], BoxedUnit> apply(scala.collection.immutable.Seq<NodeFactory<?>> nodeFactories, scala.collection.immutable.Seq<EdgeFactory<?>> edgeFactories, Function1<Object, Object> convertPropertyForPersistence) {
        return (Function1 & Serializable)args -> {
            ImporterMain$.$anonfun$apply$1(nodeFactories, edgeFactories, convertPropertyForPersistence, args);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<Object, Object> apply$default$3() {
        return (Function1 & Serializable)x -> Predef$.MODULE$.identity(x);
    }

    private OParserBuilder<ImporterMain.Config> builder$lzycompute() {
        ImporterMain$ importerMain$ = this;
        synchronized (importerMain$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                builder = OParser$.MODULE$.builder();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return builder;
    }

    private OParserBuilder<ImporterMain.Config> builder() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.builder$lzycompute();
        }
        return builder;
    }

    private OParser<BoxedUnit, ImporterMain.Config> parser$lzycompute() {
        ImporterMain$ importerMain$ = this;
        synchronized (importerMain$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                parser = OParser$.MODULE$.sequence(this.builder().programName("odb-import"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{this.builder().help("help").text("prints this usage text"), this.builder().opt('f', "format", Read$.MODULE$.stringRead()).required().action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$1 = (Enumeration.Value)package$Format$.MODULE$.byNameLowercase().apply(x);
                    scala.collection.immutable.Seq<Path> x$2 = c.copy$default$1();
                    Path x$3 = c.copy$default$3();
                    return c.copy(x$2, x$1, x$3);
                }).text(new StringBuilder(24).append("import format, one of [").append(package$Format$.MODULE$.valuesAsStringLowercase().mkString("|")).append("]").toString()), this.builder().opt('o', "out", Read$.MODULE$.fileRead()).required().action((Function2 & Serializable)(x, c) -> {
                    Path x$4 = x.toPath();
                    scala.collection.immutable.Seq<Path> x$5 = c.copy$default$1();
                    Enumeration.Value x$6 = c.copy$default$2();
                    return c.copy(x$5, x$6, x$4);
                }).text("output file for overflowdb binary, e.g. out.odb"), this.builder().arg("inputFiles", Read$.MODULE$.fileRead()).required().unbounded().action((Function2 & Serializable)(x, c) -> c.copy((scala.collection.immutable.Seq<Path>)((scala.collection.immutable.Seq)c.inputFiles().$colon$plus((Object)x.toPath())), c.copy$default$2(), c.copy$default$3())).text("input files - must exist and be readable")}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return parser;
    }

    private OParser<BoxedUnit, ImporterMain.Config> parser() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.parser$lzycompute();
        }
        return parser;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Path x$1) {
        return Files.exists(x$1, new LinkOption[0]);
    }

    public static final /* synthetic */ void $anonfun$apply$5(scala.collection.immutable.Seq inputFiles$1, Enumeration.Value format$1, Path outputFile$1, Importer importer$1, Graph graph) {
        MODULE$.logger().info(new StringBuilder(85).append("starting import of ").append(inputFiles$1.size()).append(" files in format=").append(format$1).append(" into a new overflowdb instance with storagePath=").append(outputFile$1).toString());
        importer$1.runImport(graph, (scala.collection.immutable.Seq<Path>)inputFiles$1);
        MODULE$.logger().info("import completed successfully");
    }

    public static final /* synthetic */ void $anonfun$apply$2(scala.collection.immutable.Seq nodeFactories$1, scala.collection.immutable.Seq edgeFactories$1, Function1 convertPropertyForPersistence$1, ImporterMain.Config x0$1) {
        ImporterMain.Config config = x0$1;
        if (config != null) {
            Importer importer;
            scala.collection.immutable.Seq<Path> inputFiles = config.inputFiles();
            Enumeration.Value format = config.format();
            Path outputFile = config.outputFile();
            scala.collection.immutable.Seq nonExistent = (scala.collection.immutable.Seq)inputFiles.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ImporterMain$.$anonfun$apply$3(x$1)));
            if (nonExistent.nonEmpty()) {
                throw new AssertionError((Object)new StringBuilder(31).append("given input files ").append(nonExistent).append(" do not exist").toString());
            }
            Files.deleteIfExists(outputFile);
            Enumeration.Value value = format;
            Enumeration.Value value2 = package$Format$.MODULE$.Neo4jCsv();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                importer = Neo4jCsvImporter$.MODULE$;
            } else {
                Enumeration.Value value4 = package$Format$.MODULE$.GraphML();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    importer = GraphMLImporter$.MODULE$;
                } else {
                    Enumeration.Value value6 = package$Format$.MODULE$.GraphSON();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        importer = GraphSONImporter$.MODULE$;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Neo4jCsvImporter$ importer2 = importer;
            Config odbConfig = Config.withoutOverflow().withStorageLocation(outputFile);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Using$.MODULE$.resource((Object)Graph.open((Config)odbConfig, (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)nodeFactories$1).asJava(), (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)edgeFactories$1).asJava(), x$2 -> convertPropertyForPersistence$1.apply(x$2)), (Function1 & Serializable)graph -> {
                ImporterMain$.$anonfun$apply$5(inputFiles, format, outputFile, importer2, graph);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        throw new MatchError((Object)config);
    }

    public static final /* synthetic */ void $anonfun$apply$1(scala.collection.immutable.Seq nodeFactories$1, scala.collection.immutable.Seq edgeFactories$1, Function1 convertPropertyForPersistence$1, String[] args) {
        OParser$.MODULE$.parse(MODULE$.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ImporterMain.Config((scala.collection.immutable.Seq<Path>)Nil$.MODULE$, null, Paths.get("/dev/null", new String[0]))).map((Function1 & Serializable)x0$1 -> {
            ImporterMain$.$anonfun$apply$2(nodeFactories$1, edgeFactories$1, convertPropertyForPersistence$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private ImporterMain$() {
    }
}

