/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.dot;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import overflowdb.Edge;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.util.Using;
import scala.util.Using$;

public final class DotExporter$
implements Exporter {
    public static final DotExporter$ MODULE$ = new DotExporter$();

    static {
        Exporter.$init$(MODULE$);
    }

    @Override
    public ExportResult runExport(Graph graph, Path outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public ExportResult runExport(Graph graph, String outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public String defaultFileExtension() {
        return "dot";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, new StringBuilder(7).append("export.").append(this.defaultFileExtension()).toString());
        IntRef nodeCount = IntRef.create((int)0);
        IntRef edgeCount = IntRef.create((int)0);
        Using$.MODULE$.resource((Object)Files.newBufferedWriter(outFile, new OpenOption[0]), (Function1 & Serializable)writer -> {
            DotExporter$.$anonfun$runExport$1(nodes, nodeCount, edges, edgeCount, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return new ExportResult(nodeCount.elem, edgeCount.elem, (Seq<Path>)new .colon.colon((Object)outFile, (List)Nil$.MODULE$), (Option<String>)None$.MODULE$);
    }

    private String node2Dot(Node node) {
        return new StringBuilder(12).append("  ").append(node.id()).append(" [label=").append(node.label()).append(" ").append(this.properties2Dot(node.propertiesMap())).append("]").toString();
    }

    private String edge2Dot(Edge edge) {
        return new StringBuilder(16).append("  ").append(edge.outNode().id()).append(" -> ").append(edge.inNode().id()).append(" [label=").append(edge.label()).append(" ").append(this.properties2Dot(edge.propertiesMap())).append("]").toString();
    }

    private String properties2Dot(Map<String, Object> properties) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(properties).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return new StringBuilder(1).append(key).append("=").append(MODULE$.encodePropertyValue(value)).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(" ");
    }

    private String encodePropertyValue(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            String escaped = string.replace("\\", "\\\\").replace("\"", "\\\"");
            return new StringBuilder(2).append("\"").append(escaped).append("\"").toString();
        }
        if (package$.MODULE$.iterableForList().isDefinedAt(object)) {
            String values = ((IterableOnceOps)package$.MODULE$.iterableForList().apply(object)).mkString(";");
            return new StringBuilder(2).append("\"").append(values).append("\"").toString();
        }
        return object.toString();
    }

    private static final void writeLine$1(String line, BufferedWriter writer$1) {
        writer$1.write(line);
        writer$1.newLine();
    }

    public static final /* synthetic */ void $anonfun$runExport$2(IntRef nodeCount$1, BufferedWriter writer$1, Node node) {
        ++nodeCount$1.elem;
        DotExporter$.writeLine$1(MODULE$.node2Dot(node), writer$1);
    }

    public static final /* synthetic */ void $anonfun$runExport$3(IntRef edgeCount$1, BufferedWriter writer$1, Edge edge) {
        ++edgeCount$1.elem;
        DotExporter$.writeLine$1(MODULE$.edge2Dot(edge), writer$1);
    }

    public static final /* synthetic */ void $anonfun$runExport$1(IterableOnce nodes$1, IntRef nodeCount$1, IterableOnce edges$1, IntRef edgeCount$1, BufferedWriter writer) {
        DotExporter$.writeLine$1("digraph {", writer);
        nodes$1.iterator().foreach((Function1 & Serializable)node -> {
            DotExporter$.$anonfun$runExport$2(nodeCount$1, writer, node);
            return BoxedUnit.UNIT;
        });
        edges$1.iterator().foreach((Function1 & Serializable)edge -> {
            DotExporter$.$anonfun$runExport$3(edgeCount$1, writer, edge);
            return BoxedUnit.UNIT;
        });
        DotExporter$.writeLine$1("}", writer);
    }

    private DotExporter$() {
    }
}

