/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphml;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.graphml.package;
import overflowdb.formats.graphml.package$Type$;
import overflowdb.formats.package$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.PrettyPrinter;
import scala.xml.Utility$;
import scala.xml.XML$;

public final class GraphMLExporter$
implements Exporter {
    public static final GraphMLExporter$ MODULE$ = new GraphMLExporter$();

    static {
        Exporter.$init$(MODULE$);
    }

    @Override
    public ExportResult runExport(Graph graph, Path outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public ExportResult runExport(Graph graph, String outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public String defaultFileExtension() {
        return "xml";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, new StringBuilder(7).append("export.").append(this.defaultFileExtension()).toString());
        Map nodePropertyContextById = (Map)Map$.MODULE$.empty();
        Map edgePropertyContextById = (Map)Map$.MODULE$.empty();
        AtomicInteger discardedListPropertyCount = new AtomicInteger(0);
        Seq nodeEntries = nodes.iterator().map((Function1 & Serializable)node -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(91).append("<node id=\"").append(node.id()).append("\">\n         |    <data key=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\">").append(node.label()).append("</data>\n         |    ").append(MODULE$.dataEntries("node", (Element)node, (Map<String, package.PropertyContext>)nodePropertyContextById, discardedListPropertyCount)).append("\n         |</node>\n         |").toString()))).toSeq();
        Seq edgeEntries = edges.iterator().map((Function1 & Serializable)edge -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(105).append("<edge source=\"").append(edge.outNode().id()).append("\" target=\"").append(edge.inNode().id()).append("\">\n         |    <data key=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\">").append(edge.label()).append("</data>\n         |    ").append(MODULE$.dataEntries("edge", (Element)edge, (Map<String, package.PropertyContext>)edgePropertyContextById, discardedListPropertyCount)).append("\n         |</edge>\n         |").toString()))).toSeq();
        String nodePropertyKeyEntries = GraphMLExporter$.propertyKeyXml$1("node", nodePropertyContextById);
        String edgePropertyKeyEntries = GraphMLExporter$.propertyKeyXml$1("edge", edgePropertyContextById);
        String xml = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(599).append("\n       |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n       |<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n       |  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       |  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n       |    <key id=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\" for=\"node\" attr.name=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\" attr.type=\"string\"></key>\n       |    <key id=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\" for=\"edge\" attr.name=\"").append(overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\" attr.type=\"string\"></key>\n       |    ").append(nodePropertyKeyEntries).append("\n       |    ").append(edgePropertyKeyEntries).append("\n       |    <graph id=\"G\" edgedefault=\"directed\">\n       |      ").append(nodeEntries.mkString(System.lineSeparator())).append("\n       |      ").append(edgeEntries.mkString(System.lineSeparator())).append("\n       |    </graph>\n       |</graphml>\n       |").toString())).trim();
        package$.MODULE$.writeFile(outFile, xml);
        this.xmlFormatInPlace(outFile);
        Option additionalInfo = new Some((Object)BoxesRunTime.boxToInteger((int)discardedListPropertyCount.get())).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 0).map((Function1 & Serializable)count -> GraphMLExporter$.$anonfun$runExport$5(BoxesRunTime.unboxToInt((Object)count)));
        return new ExportResult(nodeEntries.size(), edgeEntries.size(), (Seq<Path>)new .colon.colon((Object)outFile, (List)Nil$.MODULE$), (Option<String>)additionalInfo);
    }

    private String dataEntries(String prefix, Element element, Map<String, package.PropertyContext> propertyContextById, AtomicInteger discardedListPropertyCount) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(element.propertiesMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String propertyName = (String)tuple2._1();
                Object propertyValue = tuple2._2();
                if (package$.MODULE$.isList(propertyValue.getClass())) {
                    discardedListPropertyCount.incrementAndGet();
                    return "";
                }
                String encodedPropertyName = new StringBuilder(4).append(prefix).append("__").append(element.label()).append("__").append(propertyName).toString();
                Enumeration.Value graphMLTpe = package$Type$.MODULE$.fromRuntimeClass(propertyValue.getClass());
                if (!propertyContextById.contains((Object)encodedPropertyName)) {
                    propertyContextById.update((Object)encodedPropertyName, (Object)new package.PropertyContext(propertyName, graphMLTpe));
                }
                String xmlEncoded = Utility$.MODULE$.escape(propertyValue.toString());
                return new StringBuilder(20).append("<data key=\"").append(encodedPropertyName).append("\">").append(xmlEncoded).append("</data>").toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(System.lineSeparator());
    }

    private void xmlFormatInPlace(Path xmlFile) {
        Elem xml = (Elem)XML$.MODULE$.loadFile(xmlFile.toFile());
        PrettyPrinter prettyPrinter = new PrettyPrinter(120, 2);
        String formatted = prettyPrinter.format((scala.xml.Node)xml, prettyPrinter.format$default$2());
        package$.MODULE$.writeFile(xmlFile, formatted);
    }

    private static final String propertyKeyXml$1(String forAttr, Map propsMap) {
        return ((IterableOnceOps)propsMap.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                package.PropertyContext propertyContext = (package.PropertyContext)tuple2._2();
                if (propertyContext != null) {
                    String name = propertyContext.name();
                    Enumeration.Value tpe = propertyContext.tpe();
                    return new StringBuilder(50).append("<key id=\"").append(key).append("\" for=\"").append(forAttr).append("\" attr.name=\"").append(name).append("\" attr.type=\"").append(tpe).append("\"></key>").toString();
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString(System.lineSeparator());
    }

    public static final /* synthetic */ String $anonfun$runExport$5(int count) {
        return new StringBuilder(88).append("warning: discarded ").append(count).append(" list properties (because they are not supported by the graphml spec)").toString();
    }

    private GraphMLExporter$() {
    }
}

