/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphml;

import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.Importer;
import overflowdb.formats.graphml.package;
import overflowdb.formats.graphml.package$;
import overflowdb.formats.graphml.package$Type$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class GraphMLImporter$
implements Importer {
    public static final GraphMLImporter$ MODULE$ = new GraphMLImporter$();
    private static Logger logger;

    static {
        Importer.$init$(MODULE$);
    }

    @Override
    public void runImport(Graph graph, Path inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public void runImport(Graph graph, String inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void overflowdb$formats$Importer$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        Predef$.MODULE$.assert(inputFiles.size() == 1, (Function0 & Serializable)() -> new StringBuilder(40).append("input must be exactly one file, but got ").append(inputFiles.size()).toString());
        Elem doc = (Elem)XML$.MODULE$.loadFile(((Path)inputFiles.head()).toFile());
        NodeSeq keyEntries = doc.$bslash("key");
        NodeSeq graphXml = doc.$bslash("graph");
        Map<String, package.PropertyContext> nodePropertyContextById = this.parsePropertyEntries("node", keyEntries);
        graphXml.$bslash("node").foreach((Function1 & Serializable)node -> {
            GraphMLImporter$.MODULE$.addNode(graph, node, (Map<String, package.PropertyContext>)nodePropertyContextById);
            return BoxedUnit.UNIT;
        });
        Map<String, package.PropertyContext> edgePropertyContextById = this.parsePropertyEntries("edge", keyEntries);
        graphXml.$bslash("edge").foreach((Function1 & Serializable)edge -> {
            GraphMLImporter$.MODULE$.addEdge(graph, edge, (Map<String, package.PropertyContext>)edgePropertyContextById);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, package.PropertyContext> parsePropertyEntries(String forElementType, NodeSeq keyEntries) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)keyEntries.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GraphMLImporter$.$anonfun$parsePropertyEntries$1(forElementType, x$1)))).map((Function1 & Serializable)node -> {
            String id = node.$bslash$at("id");
            String name = node.$bslash$at("attr.name");
            String graphmlType = node.$bslash$at("attr.type");
            return new Tuple2((Object)id, (Object)new package.PropertyContext(name, package$Type$.MODULE$.withName(graphmlType)));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void addNode(Graph graph, scala.xml.Node node, Map<String, package.PropertyContext> propertyContextById) {
        String id2 = node.$bslash$at("id");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        node.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForNodeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                label$1.elem = Option$.MODULE$.apply((Object)value);
                return BoxedUnit.UNIT;
            }
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.get((Object)string).getOrElse((Function0 & Serializable)() -> {
                throw new AssertionError((Object)new StringBuilder(36).append("key ").append(string).append(" not found in propertyContext...").toString());
            });
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            String name = propertyContext.name();
            Enumeration.Value tpe = propertyContext.tpe();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = MODULE$.convertValue(value, tpe2, node);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(id2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> ((Option)label$1.elem).foreach((Function1 & Serializable)label -> graph.addNode(id, label, ScalaRunTime$.MODULE$.toObjectArray(((IterableOnceOps)keyValuePairs.result()).toArray(ClassTag$.MODULE$.Any())))));
    }

    private void addEdge(Graph graph, scala.xml.Node edge, Map<String, package.PropertyContext> propertyContextById) {
        String sourceId2 = edge.$bslash$at("source");
        String targetId = edge.$bslash$at("target");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        edge.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForEdgeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                label$2.elem = Option$.MODULE$.apply((Object)value);
                return BoxedUnit.UNIT;
            }
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.get((Object)string).getOrElse((Function0 & Serializable)() -> {
                throw new AssertionError((Object)new StringBuilder(36).append("key ").append(string).append(" not found in propertyContext...").toString());
            });
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            String name = propertyContext.name();
            Enumeration.Value tpe = propertyContext.tpe();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = MODULE$.convertValue(value, tpe2, edge);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(sourceId2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)sourceId -> Option$.MODULE$.apply((Object)graph.node(sourceId)).foreach((Function1 & Serializable)source -> {
            GraphMLImporter$.$anonfun$addEdge$4(targetId, graph, label, keyValuePairs, source);
            return BoxedUnit.UNIT;
        }));
    }

    private Object convertValue(String stringValue, Enumeration.Value tpe, scala.xml.Node context) {
        Try<Object> try_ = this.tryConvertScalarValue(stringValue, tpe);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new AssertionError(new StringBuilder(37).append("unable to parse `").append(stringValue).append("` of tpe=").append(tpe).append(". context: ").append(context).toString(), e);
        }
        throw new MatchError(try_);
    }

    private Try<Object> tryConvertScalarValue(String stringValue, Enumeration.Value tpe) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Enumeration.Value value = tpe;
            Enumeration.Value value2 = package$Type$.MODULE$.Boolean();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(stringValue)));
            }
            Enumeration.Value value4 = package$Type$.MODULE$.Int();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(stringValue)));
            }
            Enumeration.Value value6 = package$Type$.MODULE$.Long();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue)));
            }
            Enumeration.Value value8 = package$Type$.MODULE$.Float();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue)));
            }
            Enumeration.Value value10 = package$Type$.MODULE$.Double();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue)));
            }
            Enumeration.Value value12 = package$Type$.MODULE$.String();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                return stringValue;
            }
            throw new MatchError((Object)value);
        });
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertyEntries$1(String forElementType$1, scala.xml.Node x$1) {
        String string = x$1.$bslash$at("for");
        String string2 = forElementType$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addEdge$6(ObjectRef label$2, Node source$1, Builder keyValuePairs$2, Node target) {
        ((Option)label$2.elem).foreach((Function1 & Serializable)label -> source$1.addEdge(label, target, ScalaRunTime$.MODULE$.toObjectArray(((IterableOnceOps)keyValuePairs$2.result()).toArray(ClassTag$.MODULE$.Any()))));
    }

    public static final /* synthetic */ void $anonfun$addEdge$4(String targetId$1, Graph graph$3, ObjectRef label$2, Builder keyValuePairs$2, Node source) {
        StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(targetId$1)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)targetId -> Option$.MODULE$.apply((Object)graph$3.node(targetId)).foreach((Function1 & Serializable)target -> {
            GraphMLImporter$.$anonfun$addEdge$6(label$2, source, keyValuePairs$2, target);
            return BoxedUnit.UNIT;
        }));
    }

    private GraphMLImporter$() {
    }
}

