/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphson;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeRef;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.graphson.GraphSONProtocol$;
import overflowdb.formats.graphson.package;
import overflowdb.formats.graphson.package$BooleanValue$;
import overflowdb.formats.graphson.package$DoubleValue$;
import overflowdb.formats.graphson.package$Edge$;
import overflowdb.formats.graphson.package$FloatValue$;
import overflowdb.formats.graphson.package$GraphSON$;
import overflowdb.formats.graphson.package$IntValue$;
import overflowdb.formats.graphson.package$ListValue$;
import overflowdb.formats.graphson.package$LongValue$;
import overflowdb.formats.graphson.package$StringValue$;
import overflowdb.formats.graphson.package$Vertex$;
import overflowdb.formats.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spray.json.JsValue;

public final class GraphSONExporter$
implements Exporter {
    public static final GraphSONExporter$ MODULE$ = new GraphSONExporter$();

    static {
        Exporter.$init$(MODULE$);
    }

    @Override
    public ExportResult runExport(Graph graph, Path outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public ExportResult runExport(Graph graph, String outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public String defaultFileExtension() {
        return "json";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, new StringBuilder(7).append("export.").append(this.defaultFileExtension()).toString());
        AtomicInteger propertyId = new AtomicInteger(0);
        AtomicInteger edgeId = new AtomicInteger(0);
        Seq nodeEntries = nodes.iterator().map((Function1 & Serializable)node -> new package.Vertex(new package.LongValue(node.id(), package$LongValue$.MODULE$.apply$default$2()), node.label(), MODULE$.propertyEntry((Element)node, propertyId, "g:VertexProperty"), package$Vertex$.MODULE$.apply$default$4())).toSeq();
        Seq edgeEntries = edges.iterator().map((Function1 & Serializable)edge -> {
            NodeRef inNode = edge.inNode();
            NodeRef outNode = edge.outNode();
            return new package.Edge(new package.LongValue(edgeId.getAndIncrement(), package$LongValue$.MODULE$.apply$default$2()), edge.label(), inNode.label(), outNode.label(), new package.LongValue(inNode.id(), package$LongValue$.MODULE$.apply$default$2()), new package.LongValue(outNode.id(), package$LongValue$.MODULE$.apply$default$2()), MODULE$.propertyEntry((Element)edge, propertyId, "g:Property"), package$Edge$.MODULE$.apply$default$8());
        }).toSeq();
        package.GraphSON graphSON = new package.GraphSON(new package.GraphSONElements((Seq<package.Vertex>)nodeEntries, (Seq<package.Edge>)edgeEntries), package$GraphSON$.MODULE$.apply$default$2());
        JsValue json = spray.json.package$.MODULE$.enrichAny((Object)graphSON).toJson(GraphSONProtocol$.MODULE$.graphSONFormat());
        package$.MODULE$.writeFile(outFile, json.prettyPrint());
        return new ExportResult(nodeEntries.size(), edgeEntries.size(), (Seq<Path>)new .colon.colon((Object)outFile, (List)Nil$.MODULE$), (Option<String>)Option$.MODULE$.empty());
    }

    public Map<String, package.Property> propertyEntry(Element element, AtomicInteger propertyId, String propertyType) {
        return CollectionConverters$.MODULE$.MapHasAsScala(element.propertiesMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String propertyName = (String)tuple2._1();
                Object propertyValue = tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propertyName), (Object)new package.Property(new package.LongValue(propertyId.getAndIncrement(), package$LongValue$.MODULE$.apply$default$2()), MODULE$.valueEntry(propertyValue), propertyType));
            }
            throw new MatchError((Object)tuple2);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public package.PropertyValue valueEntry(Object propertyValue2) {
        Object object = propertyValue2;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new package.ListValue((package.PropertyValue[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object2), (Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue), ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return new package.ListValue((package.PropertyValue[])((IterableOnceOps)iterable.map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue))).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.apply$default$2());
        }
        if (object instanceof IterableOnce) {
            IterableOnce iterableOnce = (IterableOnce)object;
            return new package.ListValue((package.PropertyValue[])iterableOnce.iterator().map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue)).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.apply$default$2());
        }
        if (object instanceof java.lang.Iterable) {
            java.lang.Iterable iterable = (java.lang.Iterable)object;
            return new package.ListValue((package.PropertyValue[])((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(iterable).asScala().map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue))).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new package.BooleanValue(bl, package$BooleanValue$.MODULE$.apply$default$2());
        }
        if (object instanceof String) {
            String string = (String)object;
            return new package.StringValue(string, package$StringValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return new package.DoubleValue(d, package$DoubleValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return new package.FloatValue(f, package$FloatValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return new package.IntValue(n, package$IntValue$.MODULE$.apply$default$2());
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return new package.LongValue(l, package$LongValue$.MODULE$.apply$default$2());
        }
        throw new MatchError(object);
    }

    private GraphSONExporter$() {
    }
}

