/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphson;

import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.Importer;
import overflowdb.formats.graphson.GraphSONProtocol$;
import overflowdb.formats.graphson.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class GraphSONImporter$
implements Importer {
    public static final GraphSONImporter$ MODULE$ = new GraphSONImporter$();
    private static Logger logger;

    static {
        Importer.$init$(MODULE$);
    }

    @Override
    public void runImport(Graph graph, Path inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public void runImport(Graph graph, String inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void overflowdb$formats$Importer$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        Predef$.MODULE$.assert(inputFiles.size() == 1, (Function0 & Serializable)() -> new StringBuilder(40).append("input must be exactly one file, but got ").append(inputFiles.size()).toString());
        Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(((Path)inputFiles.head()).toFile(), Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)source -> {
            GraphSONImporter$.$anonfun$runImport$2(graph, source);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private void addNode(package.Vertex n, Graph graph) {
        graph.addNode(n.id().$atvalue(), n.label(), ScalaRunTime$.MODULE$.toObjectArray(this.flattenProperties(n.properties())));
    }

    private Object flattenProperties(Map<String, package.Property> m) {
        return ((IterableOnceOps)m.view().mapValues((Function1 & Serializable)v -> {
            package.PropertyValue propertyValue = v.$atvalue();
            if (propertyValue instanceof package.ListValue) {
                package.ListValue listValue = (package.ListValue)propertyValue;
                return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])listValue.$atvalue()), (Function1 & Serializable)x$1 -> x$1.$atvalue(), ClassTag$.MODULE$.Any());
            }
            return propertyValue.$atvalue();
        }).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.Any());
    }

    private void addEdge(package.Edge e, Graph graph) {
        Node src = graph.node(e.outV().$atvalue());
        Node tgt = graph.node(e.inV().$atvalue());
        src.addEdge(e.label(), tgt, ScalaRunTime$.MODULE$.toObjectArray(this.flattenProperties(e.properties())));
    }

    public static final /* synthetic */ void $anonfun$runImport$2(Graph graph$1, BufferedSource source) {
        package.GraphSON graphSON = (package.GraphSON)spray.json.package$.MODULE$.enrichString(source.mkString()).parseJson().convertTo(GraphSONProtocol$.MODULE$.graphSONFormat());
        graphSON.$atvalue().vertices().foreach((Function1 & Serializable)n -> {
            GraphSONImporter$.MODULE$.addNode(n, graph$1);
            return BoxedUnit.UNIT;
        });
        graphSON.$atvalue().edges().foreach((Function1 & Serializable)e -> {
            GraphSONImporter$.MODULE$.addEdge(e, graph$1);
            return BoxedUnit.UNIT;
        });
    }

    private GraphSONImporter$() {
    }
}

