/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.neo4jcsv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVWriter;
import com.github.tototoshi.csv.CSVWriter$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import overflowdb.Edge;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.neo4jcsv.ColumnDefinitions;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter;
import overflowdb.formats.neo4jcsv.package$;
import overflowdb.formats.neo4jcsv.package$ColumnType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Using;
import scala.util.Using$;

public final class Neo4jCsvExporter$
implements Exporter {
    public static final Neo4jCsvExporter$ MODULE$ = new Neo4jCsvExporter$();

    static {
        Exporter.$init$(MODULE$);
    }

    @Override
    public ExportResult runExport(Graph graph, Path outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public ExportResult runExport(Graph graph, String outputFile) {
        return Exporter.runExport$((Exporter)this, graph, outputFile);
    }

    @Override
    public String defaultFileExtension() {
        return "csv";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputRootDirectory) {
        Map nodesByLabel = (Map)nodes.iterator().toSeq().groupBy((Function1 & Serializable)x$1 -> x$1.label()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvExporter$.$anonfun$runExport$2(x$2)));
        Neo4jCsvExporter.CountAndFiles countAndFiles = (Neo4jCsvExporter.CountAndFiles)((IterableOnceOps)nodesByLabel.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                Seq nodes = (Seq)tuple2._2();
                return MODULE$.exportNodes((IterableOnce<Node>)nodes, label, outputRootDirectory);
            }
            throw new MatchError((Object)tuple2);
        })).reduce((Function2 & Serializable)(x$3, x$4) -> x$3.plus((Neo4jCsvExporter.CountAndFiles)x$4));
        if (countAndFiles == null) {
            throw new MatchError((Object)countAndFiles);
        }
        int nodeCount = countAndFiles.count();
        Seq<Path> nodeFiles = countAndFiles.files();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeCount), nodeFiles);
        int nodeCount2 = tuple2._1$mcI$sp();
        Seq nodeFiles2 = (Seq)tuple2._2();
        Neo4jCsvExporter.CountAndFiles countAndFiles2 = this.exportEdges(edges, outputRootDirectory);
        if (countAndFiles2 == null) {
            throw new MatchError((Object)countAndFiles2);
        }
        int edgeCount = countAndFiles2.count();
        Seq<Path> edgeFiles = countAndFiles2.files();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)edgeCount), edgeFiles);
        int edgeCount2 = tuple22._1$mcI$sp();
        Seq edgeFiles2 = (Seq)tuple22._2();
        Path outputRootAbsolute = outputRootDirectory.toAbsolutePath();
        return new ExportResult(nodeCount2, edgeCount2, (Seq<Path>)((Seq)nodeFiles2.$plus$plus((IterableOnce)edgeFiles2)), (Option<String>)Option$.MODULE$.apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(938).append("Instructions on how to import the exported files into neo4j:\n           |Prerequisite: ensure you have neo4j community server running (enterprise and desktop may work too)\n           |e.g. download from https://neo4j.com/download-center/#community and start via `bin/neo4j console`\n           |\n           |Then, in a new terminal:\n           |```\n           |cd <neo4j_root>\n           |\n           |# if you have a fresh instance, you must first change the initial password\n           |bin/cypher-shell -u neo4j -p neo4j\n           |# exit the cypher shell\n           |\n           |# copy the data files to the `import` directory, where neo4j will find them\n           |cp ").append(outputRootAbsolute).append("/*").append(package$.MODULE$.DataFileSuffix()).append(".csv import\n           |\n           |find ").append(outputRootAbsolute).append(" -name 'nodes_*_cypher.csv' -exec bin/cypher-shell -u neo4j -p <password> --file {} \\;\n           |find ").append(outputRootAbsolute).append(" -name 'edges_*_cypher.csv' -exec bin/cypher-shell -u neo4j -p <password> --file {} \\;\n           |```\n           |").toString()))));
    }

    private Neo4jCsvExporter.CountAndFiles exportNodes(IterableOnce<Node> nodes, String label, Path outputRootDirectory) {
        Path dataFile = outputRootDirectory.resolve(new StringBuilder(10).append("nodes_").append(label).append(package$.MODULE$.DataFileSuffix()).append(".csv").toString());
        Path headerFile = outputRootDirectory.resolve(new StringBuilder(10).append("nodes_").append(label).append(package$.MODULE$.HeaderFileSuffix()).append(".csv").toString());
        Path cypherFile = outputRootDirectory.resolve(new StringBuilder(10).append("nodes_").append(label).append(package$.MODULE$.CypherFileSuffix()).append(".csv").toString());
        ObjectRef columnDefinitions = ObjectRef.create(null);
        IntRef nodeCount = IntRef.create((int)0);
        Using$.MODULE$.resource((Object)CSVWriter$.MODULE$.open(dataFile.toFile(), false, (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat()), (Function1 & Serializable)writer -> {
            Neo4jCsvExporter$.$anonfun$exportNodes$1(nodes, columnDefinitions, nodeCount, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.writeSingleLineCsv(headerFile, (Seq<Object>)((Seq)new .colon.colon((Object)package$ColumnType$.MODULE$.Id(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.Label(), (List)Nil$.MODULE$)).$plus$plus(((ColumnDefinitions)columnDefinitions.elem).propertiesWithTypes())));
        String cypherPropertyMappings = ((ColumnDefinitions)columnDefinitions.elem).propertiesMappingsForCypher(2).mkString(",\n");
        String cypherQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("LOAD CSV FROM 'file:/nodes_").append(label).append("_data.csv' AS line\n         |CREATE (:").append(label).append(" {\n         |id: toInteger(line[0]),\n         |").append(cypherPropertyMappings).append("\n         |});\n         |").toString()));
        overflowdb.formats.package$.MODULE$.writeFile(cypherFile, cypherQuery);
        return new Neo4jCsvExporter.CountAndFiles(nodeCount.elem, (Seq<Path>)new .colon.colon((Object)headerFile, (List)new .colon.colon((Object)dataFile, (List)new .colon.colon((Object)cypherFile, (List)Nil$.MODULE$))));
    }

    private Neo4jCsvExporter.CountAndFiles exportEdges(IterableOnce<Edge> edges, Path outputRootDirectory) {
        scala.collection.mutable.Map edgeFilesContextByLabel = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        IntRef count = IntRef.create((int)0);
        edges.iterator().foreach((Function1 & Serializable)edge -> {
            Neo4jCsvExporter$.$anonfun$exportEdges$1(edgeFilesContextByLabel, outputRootDirectory, count, edge);
            return BoxedUnit.UNIT;
        });
        Seq files = ((IterableOnceOps)edgeFilesContextByLabel.values().flatMap((Function1 & Serializable)x0$1 -> {
            Neo4jCsvExporter.EdgeFilesContext edgeFilesContext = x0$1;
            if (edgeFilesContext != null) {
                String label = edgeFilesContext.label();
                Path headerFile = edgeFilesContext.headerFile();
                Path dataFile = edgeFilesContext.dataFile();
                Path cypherFile = edgeFilesContext.cypherFile();
                CSVWriter dataFileWriter = edgeFilesContext.dataFileWriter();
                ColumnDefinitions columnDefinitions = edgeFilesContext.columnDefinitions();
                MODULE$.writeSingleLineCsv(headerFile, (Seq<Object>)((Seq)new .colon.colon((Object)package$ColumnType$.MODULE$.StartId(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.EndId(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.Type(), (List)Nil$.MODULE$))).$plus$plus(columnDefinitions.propertiesWithTypes())));
                dataFileWriter.flush();
                dataFileWriter.close();
                String cypherPropertyMappings = columnDefinitions.propertiesMappingsForCypher(3).mkString(",\n");
                String cypherQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(204).append("LOAD CSV FROM 'file:/edges_").append(label).append("_data.csv' AS line\n             |MATCH (a), (b)\n             |WHERE a.id = toInteger(line[0]) AND b.id = toInteger(line[1])\n             |CREATE (a)-[r:").append(label).append(" {").append(cypherPropertyMappings).append("}]->(b);\n             |").toString()));
                overflowdb.formats.package$.MODULE$.writeFile(cypherFile, cypherQuery);
                return new .colon.colon((Object)headerFile, (List)new .colon.colon((Object)dataFile, (List)new .colon.colon((Object)cypherFile, (List)Nil$.MODULE$)));
            }
            throw new MatchError((Object)edgeFilesContext);
        })).toSeq();
        return new Neo4jCsvExporter.CountAndFiles(count.elem, (Seq<Path>)files);
    }

    private void writeSingleLineCsv(Path outputFile, Seq<Object> entries) {
        Using$.MODULE$.resource((Object)CSVWriter$.MODULE$.open(outputFile.toFile(), false, (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat()), (Function1 & Serializable)writer -> {
            writer.writeRow(entries);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$runExport$2(Tuple2 x$2) {
        return ((IterableOnceOps)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$exportNodes$2(ObjectRef columnDefinitions$1, CSVWriter writer$1, IntRef nodeCount$1, Node node) {
        if ((ColumnDefinitions)columnDefinitions$1.elem == null) {
            columnDefinitions$1.elem = new ColumnDefinitions((Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)node.propertyKeys()).asScala());
        }
        .colon.colon specialColumns = new .colon.colon((Object)Long.toString(node.id()), (List)new .colon.colon((Object)node.label(), (List)Nil$.MODULE$));
        Seq<String> propertyValueColumns = ((ColumnDefinitions)columnDefinitions$1.elem).propertyValues((Function1 & Serializable)x$7 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(node.propertyOption(x$7))));
        writer$1.writeRow((Seq)specialColumns.$plus$plus(propertyValueColumns));
        ++nodeCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$exportNodes$1(IterableOnce nodes$1, ObjectRef columnDefinitions$1, IntRef nodeCount$1, CSVWriter writer) {
        nodes$1.iterator().foreach((Function1 & Serializable)node -> {
            Neo4jCsvExporter$.$anonfun$exportNodes$2(columnDefinitions$1, writer, nodeCount$1, node);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$exportEdges$1(scala.collection.mutable.Map edgeFilesContextByLabel$1, Path outputRootDirectory$2, IntRef count$1, Edge edge) {
        String label = edge.label();
        Neo4jCsvExporter.EdgeFilesContext context = (Neo4jCsvExporter.EdgeFilesContext)edgeFilesContextByLabel$1.getOrElseUpdate((Object)label, (Function0 & Serializable)() -> {
            Path headerFile = outputRootDirectory$2.resolve(new StringBuilder(10).append("edges_").append(label).append(package$.MODULE$.HeaderFileSuffix()).append(".csv").toString());
            Path dataFile = outputRootDirectory$2.resolve(new StringBuilder(10).append("edges_").append(label).append(package$.MODULE$.DataFileSuffix()).append(".csv").toString());
            Path cypherFile = outputRootDirectory$2.resolve(new StringBuilder(10).append("edges_").append(label).append(package$.MODULE$.CypherFileSuffix()).append(".csv").toString());
            CSVWriter dataFileWriter = CSVWriter$.MODULE$.open(dataFile.toFile(), false, (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat());
            ColumnDefinitions columnDefinitions = new ColumnDefinitions((Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)edge.propertyKeys()).asScala());
            return new Neo4jCsvExporter.EdgeFilesContext(label, headerFile, dataFile, cypherFile, dataFileWriter, columnDefinitions);
        });
        .colon.colon specialColumns = new .colon.colon((Object)Long.toString(edge.outNode().id()), (List)new .colon.colon((Object)Long.toString(edge.inNode().id()), (List)new .colon.colon((Object)edge.label(), (List)Nil$.MODULE$)));
        Seq<String> propertyValueColumns = context.columnDefinitions().propertyValues((Function1 & Serializable)x$8 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(edge.propertyOption(x$8))));
        context.dataFileWriter().writeRow((Seq)specialColumns.$plus$plus(propertyValueColumns));
        ++count$1.elem;
    }

    private Neo4jCsvExporter$() {
    }
}

