/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.neo4jcsv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVReader;
import com.github.tototoshi.csv.CSVReader$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.Importer;
import overflowdb.formats.neo4jcsv.Neo4jCsvImporter;
import overflowdb.formats.neo4jcsv.Neo4jCsvImporter$ColumnDef$;
import overflowdb.formats.neo4jcsv.package$;
import overflowdb.formats.neo4jcsv.package$ColumnType$;
import overflowdb.formats.neo4jcsv.package$FileType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class Neo4jCsvImporter$
implements Importer {
    public static final Neo4jCsvImporter$ MODULE$ = new Neo4jCsvImporter$();
    private static final String Neo4jAdminDoc;
    private static Logger logger;

    static {
        Importer.$init$(MODULE$);
        Neo4jAdminDoc = "https://neo4j.com/docs/operations-manual/current/tools/neo4j-admin/neo4j-admin-import";
    }

    @Override
    public void runImport(Graph graph, Path inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public void runImport(Graph graph, String inputFile) {
        Importer.runImport$((Importer)this, graph, inputFile);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void overflowdb$formats$Importer$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public String Neo4jAdminDoc() {
        return Neo4jAdminDoc;
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        IntRef importedNodeCount = IntRef.create((int)0);
        IntRef importedEdgeCount = IntRef.create((int)0);
        ((IterableOnceOps)this.groupInputFiles(inputFiles).sortBy((Function1 & Serializable)headerAndDataFile -> BoxesRunTime.boxToInteger((int)Neo4jCsvImporter$.MODULE$.nodeFilesFirst(headerAndDataFile)), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            Neo4jCsvImporter$.$anonfun$runImport$2(graph, importedNodeCount, importedEdgeCount, x0$1);
            return BoxedUnit.UNIT;
        });
        this.logger().info(new StringBuilder(15).append("imported ").append(importedNodeCount.elem).append(" nodes").toString());
    }

    private Seq<Neo4jCsvImporter.HeaderAndDataFile> groupInputFiles(Seq<Path> inputFiles) {
        Seq nonCsvFiles = (Seq)inputFiles.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$groupInputFiles$1(x$1)));
        Predef$.MODULE$.assert(nonCsvFiles.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(70).append("input files must all have `.csv` extension, which is not the case for ").append(nonCsvFiles.mkString(",")).toString());
        Tuple2 tuple2 = inputFiles.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$groupInputFiles$3(x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq headerFiles = (Seq)tuple2._1();
        Seq dataFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)headerFiles, (Object)dataFiles);
        Seq headerFiles2 = (Seq)tuple22._1();
        Seq dataFiles2 = (Seq)tuple22._2();
        Predef$.MODULE$.assert(headerFiles2.size() == dataFiles2.size(), (Function0 & Serializable)() -> new StringBuilder(82).append("number of header files (`xyz").append(package$.MODULE$.HeaderFileSuffix()).append(".csv`) must equal the number of data files (`xyz.csv`)").toString());
        return (Seq)headerFiles2.map((Function1 & Serializable)headerFile -> {
            String wantedBodyFilename = ((Object)headerFile.getFileName()).toString().replaceAll(package$.MODULE$.HeaderFileSuffix(), package$.MODULE$.DataFileSuffix());
            Option option = dataFiles2.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$groupInputFiles$6(wantedBodyFilename, x$4)));
            if (option instanceof Some) {
                Some some = (Some)option;
                Path dataFile = (Path)some.value();
                return new Neo4jCsvImporter.HeaderAndDataFile(MODULE$.parseHeaderFile((Path)headerFile), dataFile);
            }
            if (None$.MODULE$.equals(option)) {
                String inputFilenames = ((IterableOnceOps)inputFiles.map((Function1 & Serializable)x$5 -> x$5.getFileName())).mkString(", ");
                throw new AssertionError((Object)new StringBuilder(61).append("body filename `").append(wantedBodyFilename).append("` wanted, but not found in given input files: ").append(inputFilenames).toString());
            }
            throw new MatchError((Object)option);
        });
    }

    private int nodeFilesFirst(Neo4jCsvImporter.HeaderAndDataFile headerAndDataFile) {
        Enumeration.Value value = headerAndDataFile.headerFile().fileType();
        Enumeration.Value value2 = package$FileType$.MODULE$.Nodes();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return 1;
        }
        Enumeration.Value value4 = package$FileType$.MODULE$.Relationships();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return 2;
        }
        throw new MatchError((Object)value);
    }

    private Neo4jCsvImporter.ParsedHeaderFile parseHeaderFile(Path headerFile) {
        List columnDefs = (List)Using$.MODULE$.resource((Object)CSVReader$.MODULE$.open(headerFile.toFile(), (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat()), (Function1 & Serializable)headerReader -> (List)headerReader.all().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(21).append("header file ").append(headerFile).append(" is empty").toString());
        }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Builder propertyDefs = Predef$.MODULE$.Map().newBuilder();
        BooleanRef labelColumnFound = BooleanRef.create((boolean)false);
        ObjectRef fileType = ObjectRef.create((Object)None$.MODULE$);
        ((List)columnDefs.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            block4: {
                Neo4jCsvImporter.ColumnDef columnDef;
                int idx;
                block6: {
                    String string;
                    block11: {
                        String valueTpe0;
                        String name;
                        block13: {
                            List list;
                            block12: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block5: {
                                                    tuple2 = x0$1;
                                                    if (tuple2 == null) break block4;
                                                    String entry = (String)tuple2._1();
                                                    idx = tuple2._2$mcI$sp();
                                                    string = entry;
                                                    String string2 = package$ColumnType$.MODULE$.LabelMarker();
                                                    String string3 = string;
                                                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                                                    if (labelColumnFound$1.elem) {
                                                        throw new NotImplementedError(new StringBuilder(65).append("multiple ").append(package$ColumnType$.MODULE$.Label()).append(" columns found in ").append(headerFile).append(", which is not supported by overflowdb").toString());
                                                    }
                                                    labelColumnFound$1.elem = true;
                                                    fileType$2.elem = Option$.MODULE$.apply((Object)package$FileType$.MODULE$.Nodes());
                                                    columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Label(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                                                    break block6;
                                                }
                                                String string4 = package$ColumnType$.MODULE$.TypeMarker();
                                                String string5 = string;
                                                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
                                                fileType$2.elem = Option$.MODULE$.apply((Object)package$FileType$.MODULE$.Relationships());
                                                columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Type(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                                                break block6;
                                            }
                                            if (!string.endsWith(package$ColumnType$.MODULE$.Id().toString())) break block8;
                                            columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Id(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                                            break block6;
                                        }
                                        if (!string.endsWith(package$ColumnType$.MODULE$.StartId().toString())) break block9;
                                        columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.StartId(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                                        break block6;
                                    }
                                    if (!string.endsWith(package$ColumnType$.MODULE$.EndId().toString())) break block10;
                                    columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.EndId(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                                    break block6;
                                }
                                if (!string.contains(":")) break block11;
                                list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(string), ':')).toList();
                                if (!(list instanceof .colon.colon)) break block12;
                                .colon.colon colon2 = (.colon.colon)list;
                                name = (String)colon2.head();
                                List list2 = colon2.next$access$1();
                                if (!(list2 instanceof .colon.colon)) break block12;
                                .colon.colon colon3 = (.colon.colon)list2;
                                valueTpe0 = (String)colon3.head();
                                List list3 = colon3.next$access$1();
                                if (Nil$.MODULE$.equals(list3)) break block13;
                            }
                            throw new MatchError((Object)list);
                        }
                        Tuple2 tuple22 = new Tuple2((Object)name, (Object)valueTpe0);
                        String name2 = (String)tuple22._1();
                        String valueTpe02 = (String)tuple22._2();
                        boolean isArray = string.endsWith(package$ColumnType$.MODULE$.ArrayMarker());
                        String valueTpe = isArray ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(valueTpe02), 2) : valueTpe02;
                        columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)Option$.MODULE$.apply((Object)name2), package$ColumnType$.MODULE$.withName(valueTpe), isArray);
                        break block6;
                    }
                    columnDef = new Neo4jCsvImporter.ColumnDef((Option<String>)Option$.MODULE$.apply((Object)string), package$ColumnType$.MODULE$.String(), Neo4jCsvImporter$ColumnDef$.MODULE$.apply$default$3());
                }
                Neo4jCsvImporter.ColumnDef propertyDef = columnDef;
                return (Builder)propertyDefs.addOne((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), (Object)propertyDef));
            }
            throw new MatchError((Object)tuple2);
        });
        Map propertyDefsRes = (Map)propertyDefs.result();
        boolean bl = false;
        Some some = null;
        Option option = (Option)fileType.elem;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Enumeration.Value value = (Enumeration.Value)some.value();
            Enumeration.Value value2 = package$FileType$.MODULE$.Nodes();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Predef$.MODULE$.assert(propertyDefsRes.values().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$parseHeaderFile$4(x$7))), (Function0 & Serializable)() -> new StringBuilder(62).append("no :ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(MODULE$.Neo4jAdminDoc()).toString());
                return new Neo4jCsvImporter.ParsedHeaderFile(package$FileType$.MODULE$.Nodes(), (Map<Object, Neo4jCsvImporter.ColumnDef>)propertyDefsRes);
            }
        }
        if (bl) {
            Enumeration.Value value = (Enumeration.Value)some.value();
            Enumeration.Value value4 = package$FileType$.MODULE$.Relationships();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Predef$.MODULE$.assert(propertyDefsRes.values().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$parseHeaderFile$6(x$8))), (Function0 & Serializable)() -> new StringBuilder(68).append("no :START_ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(MODULE$.Neo4jAdminDoc()).toString());
                Predef$.MODULE$.assert(propertyDefsRes.values().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Neo4jCsvImporter$.$anonfun$parseHeaderFile$8(x$9))), (Function0 & Serializable)() -> new StringBuilder(66).append("no :END_ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(MODULE$.Neo4jAdminDoc()).toString());
                return new Neo4jCsvImporter.ParsedHeaderFile(package$FileType$.MODULE$.Relationships(), (Map<Object, Neo4jCsvImporter.ColumnDef>)propertyDefsRes);
            }
        }
        throw new AssertionError((Object)new StringBuilder(83).append("unable to determine file type - neither ").append(package$ColumnType$.MODULE$.Label()).append(" (for nodes) nor ").append(package$ColumnType$.MODULE$.Type()).append(" (for relationships) found").toString());
    }

    private Neo4jCsvImporter.ParsedNodeRowData parseNodeRowData(Seq<String> columnsRaw, Map<Object, Neo4jCsvImporter.ColumnDef> columnDefs, Path inputFile, int lineNo) {
        ObjectRef id = ObjectRef.create(null);
        ObjectRef label = ObjectRef.create(null);
        Builder properties = scala.package$.MODULE$.Seq().newBuilder();
        ((IterableOnceOps)columnsRaw.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Neo4jCsvImporter$.$anonfun$parseNodeRowData$1(columnDefs, inputFile, lineNo, id, label, properties, x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert((Integer)id.elem != null, (Function0 & Serializable)() -> new StringBuilder(27).append("no ID column found in line ").append(lineNo).toString());
        Predef$.MODULE$.assert((String)label.elem != null, (Function0 & Serializable)() -> new StringBuilder(30).append("no LABEL column found in line ").append(lineNo).toString());
        Neo4jCsvImporter.ParsedNodeRowData ret = new Neo4jCsvImporter.ParsedNodeRowData(Predef$.MODULE$.Integer2int((Integer)id.elem), (String)label.elem, (Seq<Neo4jCsvImporter.ParsedProperty>)((Seq)properties.result()));
        this.logger().debug("parsed line {}: {}", (Object)BoxesRunTime.boxToInteger((int)lineNo), (Object)ret);
        return ret;
    }

    private Neo4jCsvImporter.ParsedEdgeRowData parseEdgeRowData(Seq<String> columnsRaw, Map<Object, Neo4jCsvImporter.ColumnDef> columnDefs, Path inputFile, int lineNo) {
        ObjectRef startId = ObjectRef.create(null);
        ObjectRef endId = ObjectRef.create(null);
        ObjectRef label = ObjectRef.create(null);
        Builder properties = scala.package$.MODULE$.Seq().newBuilder();
        ((IterableOnceOps)columnsRaw.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Neo4jCsvImporter$.$anonfun$parseEdgeRowData$1(columnDefs, inputFile, lineNo, startId, endId, label, properties, x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert((Integer)startId.elem != null, (Function0 & Serializable)() -> new StringBuilder(33).append("no START_ID column found in line ").append(lineNo).toString());
        Predef$.MODULE$.assert((Integer)endId.elem != null, (Function0 & Serializable)() -> new StringBuilder(31).append("no END_ID column found in line ").append(lineNo).toString());
        Predef$.MODULE$.assert((String)label.elem != null, (Function0 & Serializable)() -> new StringBuilder(30).append("no LABEL column found in line ").append(lineNo).toString());
        Neo4jCsvImporter.ParsedEdgeRowData ret = new Neo4jCsvImporter.ParsedEdgeRowData(Predef$.MODULE$.Integer2int((Integer)startId.elem), Predef$.MODULE$.Integer2int((Integer)endId.elem), (String)label.elem, (Seq<Neo4jCsvImporter.ParsedProperty>)((Seq)properties.result()));
        this.logger().debug("parsed line {}: {}", (Object)BoxesRunTime.boxToInteger((int)lineNo), (Object)ret);
        return ret;
    }

    private void parseEntry(String rawValue, Neo4jCsvImporter.ColumnDef columnDef, Path inputFile, int lineNo, PartialFunction<Neo4jCsvImporter.ColumnDef, ?> handleColumn) {
        try {
            handleColumn.applyOrElse((Object)columnDef, (Function1 & Serializable)x$10 -> {
                throw new MatchError((Object)new StringBuilder(39).append("unhandled case ").append(columnDef).append(" for rawValue=").append(rawValue).append(" in ").append(inputFile.getFileName()).append(" line ").append(lineNo).toString());
            });
        }
        catch (Exception err) {
            throw new RuntimeException(new StringBuilder(58).append("error while parsing input value '").append(rawValue).append("' of valueType=").append(columnDef.valueType()).append(" in ").append(inputFile.getFileName()).append(" line ").append(lineNo).toString(), err);
        }
    }

    public Option<Neo4jCsvImporter.ParsedProperty> overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseProperty(String rawValue, String name, Enumeration.Value valueType) {
        return Option$.MODULE$.apply((Object)rawValue).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$11)))).map((Function1 & Serializable)value -> new Neo4jCsvImporter.ParsedProperty(name, MODULE$.parsePropertyValue((String)value, valueType)));
    }

    public Option<Neo4jCsvImporter.ParsedProperty> overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseArrayProperty(String rawValue, String name, Enumeration.Value valueType) {
        String[] values = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(rawValue), ';');
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])values))) {
            Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])values));
            String string = "";
            if (object == null ? string != null : !object.equals(string)) {
                Object[] parsedValues = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x$12 -> MODULE$.parsePropertyValue((String)x$12, valueType), ClassTag$.MODULE$.Any());
                return new Some((Object)new Neo4jCsvImporter.ParsedProperty(name, parsedValues));
            }
        }
        return None$.MODULE$;
    }

    private Object parsePropertyValue(String rawString, Enumeration.Value valueType) {
        Enumeration.Value value = valueType;
        Enumeration.Value value2 = package$ColumnType$.MODULE$.Int();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value4 = package$ColumnType$.MODULE$.Long();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value6 = package$ColumnType$.MODULE$.Float();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value8 = package$ColumnType$.MODULE$.Double();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value10 = package$ColumnType$.MODULE$.Boolean();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value12 = package$ColumnType$.MODULE$.Byte();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value14 = package$ColumnType$.MODULE$.Short();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value16 = package$ColumnType$.MODULE$.Char();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            return BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value18 = package$ColumnType$.MODULE$.String();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            return rawString;
        }
        Enumeration.Value value20 = package$ColumnType$.MODULE$.Point();
        Enumeration.Value value21 = value;
        if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value22 = package$ColumnType$.MODULE$.Date();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value24 = package$ColumnType$.MODULE$.LocalTime();
        Enumeration.Value value25 = value;
        if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value26 = package$ColumnType$.MODULE$.Time();
        Enumeration.Value value27 = value;
        if (!(value26 != null ? !value26.equals(value27) : value27 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value28 = package$ColumnType$.MODULE$.LocalDateTime();
        Enumeration.Value value29 = value;
        if (!(value28 != null ? !value28.equals(value29) : value29 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value30 = package$ColumnType$.MODULE$.DateTime();
        Enumeration.Value value31 = value;
        if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value32 = package$ColumnType$.MODULE$.Duration();
        Enumeration.Value value33 = value;
        if (!(value32 != null ? !value32.equals(value33) : value33 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)value);
    }

    public int overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseInt(String entry, Enumeration.Value columnType, int lineNo) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entry));
        }
        catch (Exception err) {
            throw new AssertionError(new StringBuilder(21).append(columnType).append(" is not an Int (").append(lineNo).append("): ").append(entry).append(": ").append(err).toString(), err);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$runImport$4(Map columnDefs$1, Path dataFile$1, Enumeration.Value fileType$1, Graph graph$1, IntRef importedNodeCount$1, IntRef importedEdgeCount$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq columnsRaw = (Seq)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        Predef$.MODULE$.assert(columnsRaw.size() == columnDefs$1.size(), (Function0 & Serializable)() -> new StringBuilder(92).append("datafile ").append(dataFile$1.toAbsolutePath()).append(" row must have the same column count as the headerfile (").append(columnDefs$1.size()).append(") - instead found ").append(columnsRaw.size()).append(" for row=").append(columnsRaw.mkString(",")).toString());
        int lineNo = idx + 1;
        Enumeration.Value value = fileType$1;
        Enumeration.Value value2 = package$FileType$.MODULE$.Nodes();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Neo4jCsvImporter.ParsedNodeRowData parsedNodeRowData = MODULE$.parseNodeRowData((Seq<String>)columnsRaw, (Map<Object, Neo4jCsvImporter.ColumnDef>)columnDefs$1, dataFile$1, lineNo);
            if (parsedNodeRowData == null) throw new MatchError((Object)parsedNodeRowData);
            int id = parsedNodeRowData.id();
            String label = parsedNodeRowData.label();
            Seq<Neo4jCsvImporter.ParsedProperty> properties = parsedNodeRowData.properties();
            Seq propertiesAsKeyValues = (Seq)properties.flatMap((Function1 & Serializable)parsedProperty -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{parsedProperty.name(), parsedProperty.value()})));
            graph$1.addNode((long)id, label, ScalaRunTime$.MODULE$.toObjectArray(propertiesAsKeyValues.toArray(ClassTag$.MODULE$.Any())));
            ++importedNodeCount$1.elem;
            return;
        } else {
            Enumeration.Value value4 = package$FileType$.MODULE$.Relationships();
            Enumeration.Value value5 = value;
            if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
            Neo4jCsvImporter.ParsedEdgeRowData parsedEdgeRowData = MODULE$.parseEdgeRowData((Seq<String>)columnsRaw, (Map<Object, Neo4jCsvImporter.ColumnDef>)columnDefs$1, dataFile$1, lineNo);
            if (parsedEdgeRowData == null) throw new MatchError((Object)parsedEdgeRowData);
            int startId = parsedEdgeRowData.startId();
            int endId = parsedEdgeRowData.endId();
            String label = parsedEdgeRowData.label();
            Seq<Neo4jCsvImporter.ParsedProperty> properties = parsedEdgeRowData.properties();
            Node startNode = graph$1.node((long)startId);
            Node endNode = graph$1.node((long)endId);
            HashMap propertiesMap = new HashMap();
            properties.foreach((Function1 & Serializable)x0$3 -> {
                Neo4jCsvImporter.ParsedProperty parsedProperty = x0$3;
                if (parsedProperty != null) {
                    String name = parsedProperty.name();
                    Object value = parsedProperty.value();
                    return propertiesMap.put(name, value);
                }
                throw new MatchError((Object)parsedProperty);
            });
            startNode.addEdge(label, endNode, propertiesMap);
            ++importedEdgeCount$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$runImport$3(Map columnDefs$1, Path dataFile$1, Enumeration.Value fileType$1, Graph graph$1, IntRef importedNodeCount$1, IntRef importedEdgeCount$1, CSVReader dataReader) {
        dataReader.iterator().zipWithIndex().foreach((Function1 & Serializable)x0$2 -> {
            Neo4jCsvImporter$.$anonfun$runImport$4(columnDefs$1, dataFile$1, fileType$1, graph$1, importedNodeCount$1, importedEdgeCount$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runImport$2(Graph graph$1, IntRef importedNodeCount$1, IntRef importedEdgeCount$1, Neo4jCsvImporter.HeaderAndDataFile x0$1) {
        Neo4jCsvImporter.HeaderAndDataFile headerAndDataFile = x0$1;
        if (headerAndDataFile != null) {
            Neo4jCsvImporter.ParsedHeaderFile parsedHeaderFile = headerAndDataFile.headerFile();
            Path dataFile = headerAndDataFile.dataFile();
            if (parsedHeaderFile != null) {
                Enumeration.Value fileType = parsedHeaderFile.fileType();
                Map<Object, Neo4jCsvImporter.ColumnDef> columnDefs = parsedHeaderFile.propertyByColumnIndex();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Using$.MODULE$.resource((Object)CSVReader$.MODULE$.open(dataFile.toFile(), (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat()), (Function1 & Serializable)dataReader -> {
                    Neo4jCsvImporter$.$anonfun$runImport$3(columnDefs, dataFile, fileType, graph$1, importedNodeCount$1, importedEdgeCount$1, dataReader);
                    return BoxedUnit.UNIT;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                return;
            }
        }
        throw new MatchError((Object)headerAndDataFile);
    }

    public static final /* synthetic */ boolean $anonfun$groupInputFiles$1(Path x$1) {
        return ((Object)x$1.getFileName()).toString().endsWith(".csv");
    }

    public static final /* synthetic */ boolean $anonfun$groupInputFiles$3(Path x$2) {
        return ((Object)x$2.getFileName()).toString().endsWith(new StringBuilder(4).append(package$.MODULE$.HeaderFileSuffix()).append(".csv").toString());
    }

    public static final /* synthetic */ boolean $anonfun$groupInputFiles$6(String wantedBodyFilename$1, Path x$4) {
        String string = ((Object)x$4.getFileName()).toString();
        String string2 = wantedBodyFilename$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseHeaderFile$4(Neo4jCsvImporter.ColumnDef x$7) {
        Enumeration.Value value = x$7.valueType();
        Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseHeaderFile$6(Neo4jCsvImporter.ColumnDef x$8) {
        Enumeration.Value value = x$8.valueType();
        Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseHeaderFile$8(Neo4jCsvImporter.ColumnDef x$9) {
        Enumeration.Value value = x$9.valueType();
        Enumeration.Value value2 = package$ColumnType$.MODULE$.EndId();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ void $anonfun$parseNodeRowData$1(Map columnDefs$2, Path inputFile$1, int lineNo$1, ObjectRef id$1, ObjectRef label$1, Builder properties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String entry = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Neo4jCsvImporter.ColumnDef columnDef = (Neo4jCsvImporter.ColumnDef)columnDefs$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)idx), (Function0 & Serializable)() -> {
                throw new AssertionError((Object)new StringBuilder(74).append("column with index=").append(idx).append(" not found in column definitions derived from headerFile").toString());
            });
            MODULE$.parseEntry(entry, columnDef, inputFile$1, lineNo$1, (PartialFunction<Neo4jCsvImporter.ColumnDef, ?>)new Serializable(id$1, entry, lineNo$1, label$1, properties$1){
                private static final long serialVersionUID = 0L;
                private final ObjectRef id$1;
                private final String entry$1;
                private final int lineNo$1;
                private final ObjectRef label$1;
                private final Builder properties$1;

                public final <A1 extends Neo4jCsvImporter.ColumnDef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Enumeration.Value value = A1.valueType();
                        Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            this.id$1.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseInt(this.entry$1, package$ColumnType$.MODULE$.Id(), this.lineNo$1));
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    if (A1 != null) {
                        Enumeration.Value value = A1.valueType();
                        Enumeration.Value value4 = package$ColumnType$.MODULE$.Label();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            this.label$1.elem = this.entry$1;
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    if (A1 != null) {
                        Option<String> option = A1.name();
                        Enumeration.Value valueType = A1.valueType();
                        boolean bl = A1.isArray();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String name = (String)some.value();
                            if (!bl) {
                                Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseProperty(this.entry$1, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)$this.properties$1.addOne(elem));
                                return (B1)BoxedUnit.UNIT;
                            }
                        }
                    }
                    if (A1 != null) {
                        Option<String> option = A1.name();
                        Enumeration.Value valueType = A1.valueType();
                        boolean bl = A1.isArray();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String name = (String)some.value();
                            if (bl) {
                                Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseArrayProperty(this.entry$1, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)$this.properties$1.addOne(elem));
                                return (B1)BoxedUnit.UNIT;
                            }
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Neo4jCsvImporter.ColumnDef x1) {
                    Neo4jCsvImporter.ColumnDef columnDef = x1;
                    if (columnDef != null) {
                        Enumeration.Value value = columnDef.valueType();
                        Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Enumeration.Value value = columnDef.valueType();
                        Enumeration.Value value4 = package$ColumnType$.MODULE$.Label();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Option<String> option = columnDef.name();
                        boolean bl = columnDef.isArray();
                        if (option instanceof Some && !bl) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Option<String> option = columnDef.name();
                        boolean bl = columnDef.isArray();
                        if (option instanceof Some && bl) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.id$1 = id$1;
                    this.entry$1 = entry$1;
                    this.lineNo$1 = lineNo$1;
                    this.label$1 = label$1;
                    this.properties$1 = properties$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(overflowdb.formats.neo4jcsv.Neo4jCsvImporter$$anonfun$$nestedInanonfun$parseNodeRowData$1$1 overflowdb.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty ), $anonfun$applyOrElse$2(overflowdb.formats.neo4jcsv.Neo4jCsvImporter$$anonfun$$nestedInanonfun$parseNodeRowData$1$1 overflowdb.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty )}, serializedLambda);
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$parseEdgeRowData$1(Map columnDefs$3, Path inputFile$2, int lineNo$2, ObjectRef startId$1, ObjectRef endId$1, ObjectRef label$2, Builder properties$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String entry = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Neo4jCsvImporter.ColumnDef columnDef = (Neo4jCsvImporter.ColumnDef)columnDefs$3.getOrElse((Object)BoxesRunTime.boxToInteger((int)idx), (Function0 & Serializable)() -> {
                throw new AssertionError((Object)new StringBuilder(74).append("column with index=").append(idx).append(" not found in column definitions derived from headerFile").toString());
            });
            MODULE$.parseEntry(entry, columnDef, inputFile$2, lineNo$2, (PartialFunction<Neo4jCsvImporter.ColumnDef, ?>)new Serializable(startId$1, entry, lineNo$2, endId$1, label$2, properties$2){
                private static final long serialVersionUID = 0L;
                private final ObjectRef startId$1;
                private final String entry$2;
                private final int lineNo$2;
                private final ObjectRef endId$1;
                private final ObjectRef label$2;
                private final Builder properties$2;

                public final <A1 extends Neo4jCsvImporter.ColumnDef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Enumeration.Value value = A1.valueType();
                        Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            this.startId$1.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseInt(this.entry$2, package$ColumnType$.MODULE$.StartId(), this.lineNo$2));
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    if (A1 != null) {
                        Enumeration.Value value = A1.valueType();
                        Enumeration.Value value4 = package$ColumnType$.MODULE$.EndId();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            this.endId$1.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseInt(this.entry$2, package$ColumnType$.MODULE$.EndId(), this.lineNo$2));
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    if (A1 != null) {
                        Enumeration.Value value = A1.valueType();
                        Enumeration.Value value6 = package$ColumnType$.MODULE$.Type();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            this.label$2.elem = this.entry$2;
                            return (B1)BoxedUnit.UNIT;
                        }
                    }
                    if (A1 != null) {
                        Option<String> option = A1.name();
                        Enumeration.Value valueType = A1.valueType();
                        boolean bl = A1.isArray();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String name = (String)some.value();
                            if (!bl) {
                                Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseProperty(this.entry$2, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)$this.properties$2.addOne(elem));
                                return (B1)BoxedUnit.UNIT;
                            }
                        }
                    }
                    if (A1 != null) {
                        Option<String> option = A1.name();
                        Enumeration.Value valueType = A1.valueType();
                        boolean bl = A1.isArray();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String name = (String)some.value();
                            if (bl) {
                                Neo4jCsvImporter$.MODULE$.overflowdb$formats$neo4jcsv$Neo4jCsvImporter$$parseArrayProperty(this.entry$2, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)$this.properties$2.addOne(elem));
                                return (B1)BoxedUnit.UNIT;
                            }
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Neo4jCsvImporter.ColumnDef x1) {
                    Neo4jCsvImporter.ColumnDef columnDef = x1;
                    if (columnDef != null) {
                        Enumeration.Value value = columnDef.valueType();
                        Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Enumeration.Value value = columnDef.valueType();
                        Enumeration.Value value4 = package$ColumnType$.MODULE$.EndId();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Enumeration.Value value = columnDef.valueType();
                        Enumeration.Value value6 = package$ColumnType$.MODULE$.Type();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Option<String> option = columnDef.name();
                        boolean bl = columnDef.isArray();
                        if (option instanceof Some && !bl) {
                            return true;
                        }
                    }
                    if (columnDef != null) {
                        Option<String> option = columnDef.name();
                        boolean bl = columnDef.isArray();
                        if (option instanceof Some && bl) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.startId$1 = startId$1;
                    this.entry$2 = entry$2;
                    this.lineNo$2 = lineNo$2;
                    this.endId$1 = endId$1;
                    this.label$2 = label$2;
                    this.properties$2 = properties$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(overflowdb.formats.neo4jcsv.Neo4jCsvImporter$$anonfun$$nestedInanonfun$parseEdgeRowData$1$1 overflowdb.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty ), $anonfun$applyOrElse$4(overflowdb.formats.neo4jcsv.Neo4jCsvImporter$$anonfun$$nestedInanonfun$parseEdgeRowData$1$1 overflowdb.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty )}, serializedLambda);
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Neo4jCsvImporter$() {
    }
}

