/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Iterator;
import java.util.NoSuchElementException;
import overflowdb.Direction;
import overflowdb.NodeRef;
import overflowdb.OdbEdge;
import overflowdb.OdbNode;

public class DummyEdgeIterator
implements Iterator<OdbEdge> {
    private final Object[] array;
    private int current;
    private final int begin;
    private final int exclusiveEnd;
    private final int strideSize;
    private final Direction direction;
    private final String label;
    private final NodeRef thisRef;

    public DummyEdgeIterator(Object[] objectArray, int n, int n2, int n3, Direction direction, String string, NodeRef nodeRef) {
        this.array = objectArray;
        this.begin = n;
        this.current = n;
        this.exclusiveEnd = n2;
        this.strideSize = n3;
        this.direction = direction;
        this.label = string;
        this.thisRef = nodeRef;
    }

    @Override
    public boolean hasNext() {
        while (this.current < this.exclusiveEnd && this.array[this.current] == null) {
            this.current += this.strideSize;
        }
        return this.current < this.exclusiveEnd;
    }

    @Override
    public OdbEdge next() {
        OdbEdge odbEdge;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        NodeRef nodeRef = (NodeRef)this.array[this.current];
        if (this.direction == Direction.OUT) {
            odbEdge = ((OdbNode)this.thisRef.get()).instantiateDummyEdge(this.label, this.thisRef, nodeRef);
            odbEdge.setOutBlockOffset(this.current - this.begin);
        } else {
            odbEdge = ((OdbNode)this.thisRef.get()).instantiateDummyEdge(this.label, nodeRef, this.thisRef);
            odbEdge.setInBlockOffset(this.current - this.begin);
        }
        this.current += this.strideSize;
        return odbEdge;
    }
}

