/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapUsageMonitor
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NotificationEmitter, NotificationListener> gcNotificationListeners = new HashMap<NotificationEmitter, NotificationListener>(2);

    public HeapUsageMonitor(int n, HeapNotificationListener heapNotificationListener) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("heapPercentageThreshold must be between 0 and 100, but is " + n);
        }
        float f = (float)n / 100.0f;
        this.installGCMonitoring(f, heapNotificationListener);
    }

    protected void installGCMonitoring(float f, HeapNotificationListener heapNotificationListener) {
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
            NotificationListener notificationListener = this.createNotificationListener(f, heapNotificationListener);
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
            notificationEmitter.addNotificationListener(notificationListener, null, null);
            this.gcNotificationListeners.put(notificationEmitter, notificationListener);
        }
        int n = (int)Math.floor(f * 100.0f);
        this.logger.info("installed GC monitors. will clear references if heap (after GC) is larger than " + n + "%");
    }

    private NotificationListener createNotificationListener(float f, HeapNotificationListener heapNotificationListener) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("Code Cache", "Compressed Class Space", "Metaspace"));
        return (notification, object) -> {
            if (notification.getType().equals("com.sun.management.gc.notification")) {
                String string;
                GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                long l = 0L;
                long l2 = 0L;
                for (Map.Entry<String, MemoryUsage> entry : garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageAfterGc().entrySet()) {
                    string = entry.getKey();
                    if (hashSet.contains(string)) continue;
                    MemoryUsage memoryUsage = entry.getValue();
                    l += memoryUsage.getUsed();
                    l2 += memoryUsage.getMax();
                }
                float f2 = (float)l / (float)l2;
                int n = (int)Math.floor(f2 * 100.0f);
                if (f2 > f) {
                    string = "heap usage after GC: " + n + "% -> will clear some references (if possible)";
                    if (n > 95) {
                        this.logger.warn(string);
                    } else {
                        this.logger.info(string);
                    }
                    heapNotificationListener.notifyHeapAboveThreshold();
                } else {
                    this.logger.trace("heap usage after GC: " + n + "%");
                }
            }
        };
    }

    @Override
    public void close() {
        while (!this.gcNotificationListeners.isEmpty()) {
            Map.Entry<NotificationEmitter, NotificationListener> entry = this.gcNotificationListeners.entrySet().iterator().next();
            try {
                entry.getKey().removeNotificationListener(entry.getValue());
                this.gcNotificationListeners.remove(entry.getKey());
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                throw new RuntimeException("unable to remove GC monitor", listenerNotFoundException);
            }
        }
        this.logger.info("uninstalled GC monitors.");
    }

    static interface HeapNotificationListener {
        public void notifyHeapAboveThreshold();
    }
}

