/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import overflowdb.Direction;
import overflowdb.Node;
import overflowdb.OdbEdge;
import overflowdb.OdbGraph;
import overflowdb.OdbNode;
import overflowdb.tp3.Converters;

public abstract class NodeRef<N extends OdbNode>
implements Vertex,
Node {
    public final long id;
    protected final OdbGraph graph;
    private N node;

    public NodeRef(OdbGraph odbGraph, N n) {
        this.graph = odbGraph;
        this.node = n;
        this.id = ((OdbNode)n).ref.id;
    }

    public NodeRef(OdbGraph odbGraph, long l) {
        Optional<N> optional;
        this.graph = odbGraph;
        this.id = l;
        Vertex vertex = odbGraph.vertex(l);
        if (vertex != null && (optional = ((NodeRef)vertex).getOption()).isPresent()) {
            this.node = (OdbNode)optional.get();
        }
    }

    public boolean isSet() {
        return this.node != null;
    }

    public boolean isCleared() {
        return this.node == null;
    }

    protected void clear() {
        this.node = null;
    }

    protected byte[] serializeWhenDirty() {
        N n = this.node;
        if (n != null && ((OdbNode)n).isDirty()) {
            return this.graph.storage.serialize((OdbNode)n);
        }
        return null;
    }

    protected void persist(byte[] byArray) {
        this.graph.storage.persist(this.id, byArray);
    }

    public final N get() {
        N n = this.node;
        if (n != null) {
            return n;
        }
        try {
            return this.getSynchronized();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private final synchronized N getSynchronized() throws IOException {
        N n = this.node;
        if (n != null) {
            return n;
        }
        N n2 = this.readFromDisk(this.id);
        if (n2 == null) {
            throw new IllegalStateException("unable to read node from disk; id=" + this.id);
        }
        this.node = n2;
        this.graph.referenceManager.registerRef(this);
        return n2;
    }

    public final Optional<N> getOption() {
        return Optional.ofNullable(this.node);
    }

    public void setNode(N n) {
        this.node = n;
    }

    private final N readFromDisk(long l) throws IOException {
        return (N)((OdbNode)this.graph.storage.readNode(l));
    }

    public Object id() {
        return this.id;
    }

    @Override
    public long id2() {
        return this.id;
    }

    public OdbGraph graph() {
        return this.graph;
    }

    @Override
    public OdbGraph graph2() {
        return this.graph;
    }

    @Override
    public void remove() {
        ((OdbNode)this.get()).remove();
        this.clear();
    }

    public int hashCode() {
        return Objects.hash(this.id2());
    }

    public boolean equals(Object object) {
        return object instanceof Node && this.id2() == ((Node)object).id2();
    }

    public Edge addEdge(String string, Vertex vertex, Object ... objectArray) {
        return ((OdbNode)this.get()).addEdge(string, vertex, objectArray);
    }

    @Override
    public OdbEdge addEdge2(String string, Node node, Object ... objectArray) {
        return ((OdbNode)this.get()).addEdge2(string, node, objectArray);
    }

    @Override
    public OdbEdge addEdge2(String string, Node node, Map<String, Object> map) {
        return ((OdbNode)this.get()).addEdge2(string, node, map);
    }

    @Override
    public void addEdgeSilent(String string, Node node, Object ... objectArray) {
        ((OdbNode)this.get()).addEdgeSilent(string, node, objectArray);
    }

    @Override
    public void addEdgeSilent(String string, Node node, Map<String, Object> map) {
        ((OdbNode)this.get()).addEdgeSilent(string, node, map);
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String string, V v, Object ... objectArray) {
        return ((OdbNode)this.get()).property(cardinality, string, v, objectArray);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... stringArray) {
        return ((OdbNode)this.get()).properties(stringArray);
    }

    @Override
    public Map<String, Object> propertyMap() {
        return ((OdbNode)this.get()).propertyMap();
    }

    @Override
    public <P> P property2(String string) {
        return ((OdbNode)this.get()).property2(string);
    }

    @Override
    public <P> void setProperty(String string, P p) {
        ((OdbNode)this.get()).setProperty(string, p);
    }

    public Iterator<Edge> edges(org.apache.tinkerpop.gremlin.structure.Direction direction, String ... stringArray) {
        return ((OdbNode)this.get()).edges(direction, stringArray);
    }

    public Iterator<Vertex> vertices(org.apache.tinkerpop.gremlin.structure.Direction direction, String ... stringArray) {
        return this.nodes(Converters.fromTinker(direction), stringArray);
    }

    public Iterator<Vertex> nodes(Direction direction, String ... stringArray) {
        return ((OdbNode)this.get()).nodes(direction, stringArray);
    }

    @Override
    public Iterator<Node> out() {
        return ((OdbNode)this.get()).out();
    }

    @Override
    public Iterator<Node> out(String ... stringArray) {
        return ((OdbNode)this.get()).out(stringArray);
    }

    @Override
    public Iterator<Node> in() {
        return ((OdbNode)this.get()).in();
    }

    @Override
    public Iterator<Node> in(String ... stringArray) {
        return ((OdbNode)this.get()).in(stringArray);
    }

    @Override
    public Iterator<Node> both() {
        return ((OdbNode)this.get()).both();
    }

    @Override
    public Iterator<Node> both(String ... stringArray) {
        return ((OdbNode)this.get()).both(stringArray);
    }

    @Override
    public Iterator<OdbEdge> outE() {
        return ((OdbNode)this.get()).outE();
    }

    @Override
    public Iterator<OdbEdge> outE(String ... stringArray) {
        return ((OdbNode)this.get()).outE(stringArray);
    }

    @Override
    public Iterator<OdbEdge> inE() {
        return ((OdbNode)this.get()).inE();
    }

    @Override
    public Iterator<OdbEdge> inE(String ... stringArray) {
        return ((OdbNode)this.get()).inE(stringArray);
    }

    @Override
    public Iterator<OdbEdge> bothE() {
        return ((OdbNode)this.get()).bothE();
    }

    @Override
    public Iterator<OdbEdge> bothE(String ... stringArray) {
        return ((OdbNode)this.get()).bothE(stringArray);
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.label() + "; id=" + this.id + "]";
    }
}

