/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Optional;

public class OdbConfig {
    private boolean overflowEnabled = true;
    private int heapPercentageThreshold = 80;
    private Optional<String> storageLocation = Optional.empty();
    private boolean serializationStatsEnabled = false;

    public static OdbConfig withDefaults() {
        return new OdbConfig();
    }

    public static OdbConfig withoutOverflow() {
        return OdbConfig.withDefaults().disableOverflow();
    }

    public OdbConfig disableOverflow() {
        this.overflowEnabled = false;
        return this;
    }

    public OdbConfig withHeapPercentageThreshold(int n) {
        this.heapPercentageThreshold = n;
        return this;
    }

    public OdbConfig withStorageLocation(String string) {
        this.storageLocation = Optional.ofNullable(string);
        return this;
    }

    public OdbConfig withSerializationStatsEnabled() {
        this.serializationStatsEnabled = true;
        return this;
    }

    public boolean isOverflowEnabled() {
        return this.overflowEnabled;
    }

    public int getHeapPercentageThreshold() {
        return this.heapPercentageThreshold;
    }

    public Optional<String> getStorageLocation() {
        return this.storageLocation;
    }

    public boolean isSerializationStatsEnabled() {
        return this.serializationStatsEnabled;
    }
}

