/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import overflowdb.Direction;
import overflowdb.NodeRef;
import overflowdb.OdbElement;
import overflowdb.OdbGraph;
import overflowdb.OdbNode;
import overflowdb.OdbProperty;

public abstract class OdbEdge
implements Edge,
OdbElement {
    private final OdbGraph graph;
    private final String label;
    private final NodeRef outNode;
    private final NodeRef inNode;
    private int outBlockOffset = -1;
    private int inBlockOffset = -1;
    private final Set<String> specificKeys;
    private boolean removed = false;
    private static final int UNINITIALIZED_BLOCK_OFFSET = -1;

    public OdbEdge(OdbGraph odbGraph, String string, NodeRef nodeRef, NodeRef nodeRef2, Set<String> set) {
        this.graph = odbGraph;
        this.label = string;
        this.outNode = nodeRef;
        this.inNode = nodeRef2;
        this.specificKeys = set;
        odbGraph.referenceManager.applyBackpressureMaybe();
    }

    public NodeRef outNode() {
        return this.outNode;
    }

    public NodeRef inNode() {
        return this.inNode;
    }

    public Iterator<NodeRef> bothNodes() {
        return IteratorUtils.of((Object)this.outNode, (Object)this.inNode);
    }

    public int getOutBlockOffset() {
        return this.outBlockOffset;
    }

    public void setOutBlockOffset(int n) {
        this.outBlockOffset = n;
    }

    public int getInBlockOffset() {
        return this.inBlockOffset;
    }

    public void setInBlockOffset(int n) {
        this.inBlockOffset = n;
    }

    public Iterator<Vertex> vertices(org.apache.tinkerpop.gremlin.structure.Direction direction) {
        switch (direction) {
            case OUT: {
                return IteratorUtils.of((Object)this.outNode);
            }
            case IN: {
                return IteratorUtils.of((Object)this.inNode);
            }
        }
        return IteratorUtils.of((Object)this.outNode, (Object)this.inNode);
    }

    public Object id() {
        return this;
    }

    @Override
    public String label() {
        return this.label;
    }

    public Graph graph() {
        return this.graph;
    }

    @Override
    public OdbGraph graph2() {
        return this.graph;
    }

    public <V> Property<V> property(String string, V v) {
        this.setProperty(string, v);
        return new OdbProperty<V>(string, v, (Element)this);
    }

    @Override
    public <P> void setProperty(String string, P p) {
        if (this.inBlockOffset != -1) {
            if (this.outBlockOffset == -1) {
                this.initializeOutFromInOffset();
            }
        } else if (this.outBlockOffset != -1) {
            if (this.inBlockOffset == -1) {
                this.initializeInFromOutOffset();
            }
        } else {
            throw new RuntimeException("Cannot set property. In and out block offset uninitialized.");
        }
        ((OdbNode)this.inNode.get()).setEdgeProperty(Direction.IN, this.label, string, p, this.inBlockOffset);
        ((OdbNode)this.outNode.get()).setEdgeProperty(Direction.OUT, this.label, string, p, this.outBlockOffset);
    }

    public Set<String> keys() {
        return this.specificKeys;
    }

    @Override
    public void remove() {
        this.fixupBlockOffsets();
        ((OdbNode)this.outNode.get()).removeEdge(Direction.OUT, this.label(), this.outBlockOffset);
        ((OdbNode)this.inNode.get()).removeEdge(Direction.IN, this.label(), this.inBlockOffset);
    }

    public <V> Iterator<Property<V>> properties(String ... stringArray) {
        if (this.inBlockOffset != -1) {
            return ((OdbNode)this.inNode.get()).getEdgeProperties(Direction.IN, this, this.getInBlockOffset(), stringArray);
        }
        if (this.outBlockOffset != -1) {
            return ((OdbNode)this.outNode.get()).getEdgeProperties(Direction.OUT, this, this.getOutBlockOffset(), stringArray);
        }
        throw new RuntimeException("Cannot get properties. In and out block offset uninitialized.");
    }

    @Override
    public Map<String, Object> propertyMap() {
        if (this.inBlockOffset != -1) {
            return ((OdbNode)this.inNode.get()).getEdgePropertyMap(Direction.IN, this, this.getInBlockOffset());
        }
        if (this.outBlockOffset != -1) {
            return ((OdbNode)this.outNode.get()).getEdgePropertyMap(Direction.OUT, this, this.getOutBlockOffset());
        }
        throw new RuntimeException("Cannot get properties. In and out block offset uninitialized.");
    }

    public <V> Property<V> property(String string) {
        if (this.inBlockOffset != -1) {
            return ((OdbNode)this.inNode.get()).getEdgeProperty(Direction.IN, this, this.inBlockOffset, string);
        }
        if (this.outBlockOffset != -1) {
            return ((OdbNode)this.outNode.get()).getEdgeProperty(Direction.OUT, this, this.outBlockOffset, string);
        }
        throw new RuntimeException("Cannot get property. In and out block offset unitialized.");
    }

    @Override
    public <P> P property2(String string) {
        if (this.inBlockOffset != -1) {
            return ((OdbNode)this.inNode.get()).getEdgeProperty2(Direction.IN, this, this.inBlockOffset, string);
        }
        if (this.outBlockOffset != -1) {
            return ((OdbNode)this.outNode.get()).getEdgeProperty2(Direction.OUT, this, this.outBlockOffset, string);
        }
        throw new RuntimeException("Cannot get property. In and out block offset unitialized.");
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OdbEdge)) {
            return false;
        }
        OdbEdge odbEdge = (OdbEdge)object;
        this.fixupBlockOffsetsIfNecessary(odbEdge);
        return !(!this.inNode.id().equals(odbEdge.inNode.id()) || !this.outNode.id().equals(odbEdge.outNode.id()) || !this.label.equals(odbEdge.label) || this.inBlockOffset != -1 && odbEdge.inBlockOffset != -1 && this.inBlockOffset != odbEdge.inBlockOffset || this.outBlockOffset != -1 && odbEdge.outBlockOffset != -1 && this.outBlockOffset != odbEdge.outBlockOffset);
    }

    public int hashCode() {
        return Objects.hash(this.inNode.id(), this.outNode.id(), this.label);
    }

    private void fixupBlockOffsetsIfNecessary(OdbEdge odbEdge) {
        if (!(this.inBlockOffset != -1 && odbEdge.inBlockOffset != -1 || this.outBlockOffset != -1 && odbEdge.outBlockOffset != -1)) {
            this.fixupBlockOffsets();
        }
    }

    private void fixupBlockOffsets() {
        if (this.inBlockOffset == -1) {
            this.initializeInFromOutOffset();
        }
        if (this.outBlockOffset == -1) {
            this.initializeOutFromInOffset();
        }
    }

    private void initializeInFromOutOffset() {
        int n = ((OdbNode)this.outNode.get()).blockOffsetToOccurrence(Direction.OUT, this.label(), this.inNode, this.outBlockOffset);
        this.inBlockOffset = ((OdbNode)this.inNode.get()).occurrenceToBlockOffset(Direction.IN, this.label(), this.outNode, n);
    }

    private void initializeOutFromInOffset() {
        int n = ((OdbNode)this.inNode.get()).blockOffsetToOccurrence(Direction.IN, this.label(), this.outNode, this.inBlockOffset);
        this.outBlockOffset = ((OdbNode)this.outNode.get()).occurrenceToBlockOffset(Direction.OUT, this.label(), this.inNode, n);
    }
}

