/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.EdgeFactory;
import overflowdb.HeapUsageMonitor;
import overflowdb.Node;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.OdbConfig;
import overflowdb.OdbEdge;
import overflowdb.OdbIndexManager;
import overflowdb.OdbNode;
import overflowdb.ReferenceManager;
import overflowdb.storage.NodeDeserializer;
import overflowdb.storage.OdbStorage;
import overflowdb.tp3.GraphVariables;
import overflowdb.tp3.TinkerIoRegistryV1d0;
import overflowdb.tp3.TinkerIoRegistryV2d0;
import overflowdb.tp3.TinkerIoRegistryV3d0;
import overflowdb.tp3.optimizations.CountStrategy;
import overflowdb.tp3.optimizations.OdbGraphStepStrategy;
import overflowdb.util.MultiIterator2;
import overflowdb.util.NodesList;
import overflowdb.util.PropertyHelper;

public final class OdbGraph
implements Graph {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphFeatures features = new GraphFeatures();
    protected final AtomicLong currentId = new AtomicLong(-1L);
    protected final NodesList nodes = new NodesList(10000);
    protected final GraphVariables variables = new GraphVariables();
    public final OdbIndexManager indexManager = new OdbIndexManager(this);
    private final OdbConfig config;
    private boolean closed = false;
    protected final Map<String, NodeFactory> nodeFactoryByLabel;
    protected final Map<String, EdgeFactory> edgeFactoryByLabel;
    protected final OdbStorage storage;
    protected final Optional<HeapUsageMonitor> heapUsageMonitor;
    protected final ReferenceManager referenceManager;

    public static OdbGraph open(OdbConfig odbConfig, List<NodeFactory<?>> list, List<EdgeFactory<?>> list2) {
        HashMap<String, NodeFactory> hashMap = new HashMap<String, NodeFactory>(list.size());
        HashMap<Integer, NodeFactory> hashMap2 = new HashMap<Integer, NodeFactory>(list.size());
        HashMap<String, EdgeFactory> hashMap3 = new HashMap<String, EdgeFactory>(list2.size());
        list.forEach(nodeFactory -> hashMap.put(nodeFactory.forLabel(), (NodeFactory)nodeFactory));
        list.forEach(nodeFactory -> hashMap2.put(nodeFactory.forLabelId(), (NodeFactory)nodeFactory));
        list2.forEach(edgeFactory -> hashMap3.put(edgeFactory.forLabel(), (EdgeFactory)edgeFactory));
        return new OdbGraph(odbConfig, hashMap, hashMap2, hashMap3);
    }

    private OdbGraph(OdbConfig odbConfig, Map<String, NodeFactory> map, Map<Integer, NodeFactory> map2, Map<String, EdgeFactory> map3) {
        this.config = odbConfig;
        this.nodeFactoryByLabel = map;
        this.edgeFactoryByLabel = map3;
        NodeDeserializer nodeDeserializer = new NodeDeserializer(this, map2, odbConfig.isSerializationStatsEnabled());
        if (odbConfig.getStorageLocation().isPresent()) {
            this.storage = OdbStorage.createWithSpecificLocation(nodeDeserializer, new File(odbConfig.getStorageLocation().get()), odbConfig.isSerializationStatsEnabled());
            this.initElementCollections(this.storage);
        } else {
            this.storage = OdbStorage.createWithTempFile(nodeDeserializer, odbConfig.isSerializationStatsEnabled());
        }
        this.referenceManager = new ReferenceManager(this.storage);
        this.heapUsageMonitor = odbConfig.isOverflowEnabled() ? Optional.of(new HeapUsageMonitor(odbConfig.getHeapPercentageThreshold(), this.referenceManager)) : Optional.empty();
    }

    private void initElementCollections(OdbStorage odbStorage) {
        long l = System.currentTimeMillis();
        Set<Map.Entry<Long, byte[]>> set = odbStorage.allNodes();
        this.logger.info("initializing " + set.size() + " nodes from existing storage - this may take some time");
        int n = 0;
        long l2 = this.currentId.get();
        for (Map.Entry<Long, byte[]> entry : set) {
            try {
                NodeRef nodeRef = odbStorage.getNodeDeserializer().get().deserializeRef(entry.getValue());
                this.nodes.add(nodeRef);
                if (++n % 131072 == 0) {
                    this.logger.debug("imported " + n + " elements - still running...");
                }
                if (nodeRef.id <= l2) continue;
                l2 = nodeRef.id;
            }
            catch (IOException iOException) {
                throw new RuntimeException("error while initializing vertex from storage: id=" + entry.getKey(), iOException);
            }
        }
        this.currentId.set(l2 + 1L);
        this.indexManager.initializeStoredIndices(odbStorage);
        long l3 = System.currentTimeMillis() - l;
        this.logger.info("initialized " + this.toString() + " from existing storage in " + l3 + "ms");
    }

    public Node addNode(String string, Object ... objectArray) {
        return this.addNode(this.currentId.incrementAndGet(), string, objectArray);
    }

    public Node addNode(long l, String string, Object ... objectArray) {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot add more elements, graph is closed");
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])objectArray);
        if (this.nodes.contains(l)) {
            throw Graph.Exceptions.vertexWithIdAlreadyExists((Object)l);
        }
        this.currentId.set(Long.max(l, this.currentId.get()));
        NodeRef nodeRef = this.createNode(l, string, objectArray);
        this.nodes.add(nodeRef);
        return nodeRef;
    }

    public Vertex addVertex(Object ... objectArray) {
        String string = ElementHelper.getLabelValue((Object[])objectArray).orElse("vertex");
        Optional<Long> optional = ElementHelper.getIdValue((Object[])objectArray).map(this::parseLong);
        long l = optional.orElseGet(() -> this.currentId.incrementAndGet());
        return this.addNode(l, string, objectArray);
    }

    private long parseLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new IllegalArgumentException(String.format("Expected an id that is convertible to Long but received %s", object.getClass()));
    }

    private NodeRef createNode(long l, String string, Object ... objectArray) {
        if (!this.nodeFactoryByLabel.containsKey(string)) {
            throw new IllegalArgumentException("No NodeFactory for label=" + string + " available.");
        }
        NodeFactory nodeFactory = this.nodeFactoryByLabel.get(string);
        Object v = nodeFactory.createNode(this, l);
        this.referenceManager.registerRef(((OdbNode)v).ref);
        NodeRef nodeRef = ((OdbNode)v).ref;
        ElementHelper.attachProperties((Vertex)nodeRef, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])objectArray);
        return nodeRef;
    }

    public <C extends GraphComputer> C compute(Class<C> clazz) {
        throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(clazz);
    }

    public GraphComputer compute() {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public Graph.Variables variables() {
        return this.variables;
    }

    public <I extends Io> I io(Io.Builder<I> builder2) {
        if (builder2.requiresVersion((Object)GryoVersion.V1_0) || builder2.requiresVersion((Object)GraphSONVersion.V1_0)) {
            return (I)builder2.graph((Graph)this).onMapper(builder -> builder.addRegistry((IoRegistry)TinkerIoRegistryV1d0.instance())).create();
        }
        if (builder2.requiresVersion((Object)GraphSONVersion.V2_0)) {
            return (I)builder2.graph((Graph)this).onMapper(builder -> builder.addRegistry((IoRegistry)TinkerIoRegistryV2d0.instance())).create();
        }
        return (I)builder2.graph((Graph)this).onMapper(builder -> builder.addRegistry((IoRegistry)TinkerIoRegistryV3d0.instance())).create();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)("nodes: " + this.nodes.size()));
    }

    public void close() {
        this.closed = true;
        this.heapUsageMonitor.ifPresent(heapUsageMonitor -> heapUsageMonitor.close());
        if (this.config.getStorageLocation().isPresent()) {
            this.indexManager.storeIndexes(this.storage);
            this.referenceManager.clearAllReferences();
        }
        this.referenceManager.close();
        this.storage.close();
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Configuration configuration() {
        throw new NotImplementedException("");
    }

    public Vertex vertex(Long l) {
        return this.node(l);
    }

    public Iterator<Vertex> vertices(Object ... objectArray) {
        if (objectArray.length == 0) {
            Iterator<Node> iterator = this.nodes.iterator();
            return IteratorUtils.map(iterator, node -> node);
        }
        long[] lArray = new long[objectArray.length];
        int n = 0;
        for (Object object : objectArray) {
            lArray[n++] = this.convertToId(object);
        }
        Iterator<Node> iterator = this.nodes(lArray);
        return IteratorUtils.map(iterator, node -> node);
    }

    private Long convertToId(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Vertex) {
            return (Long)((Vertex)object).id();
        }
        throw new IllegalArgumentException("unsupported id type: " + object.getClass() + " (" + object + "). Please pass one of [Long, OdbNode, NodeRef].");
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public int nodeCount(String string) {
        return this.nodes.cardinality(string);
    }

    public int edgeCount() {
        int n = 0;
        Iterator<OdbEdge> iterator = this.edges();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public Iterator<OdbEdge> E() {
        return this.edges();
    }

    public Iterator<OdbEdge> edges() {
        return IteratorUtils.flatMap(this.nodes(), node -> node.outE());
    }

    public Iterator<OdbEdge> edges(String string) {
        return IteratorUtils.flatMap(this.nodes(), node -> node.outE(string));
    }

    public Iterator<Edge> edges(Object ... objectArray) {
        if (objectArray.length > 0) {
            throw new IllegalArgumentException("edges only exist virtually, and they don't have ids");
        }
        MultiIterator2<Edge> multiIterator2 = new MultiIterator2<Edge>();
        this.nodes.iterator().forEachRemaining(node -> multiIterator2.addIterator(node.edges(Direction.OUT, new String[0])));
        return multiIterator2;
    }

    public Iterator<Node> V() {
        return this.nodes();
    }

    public final Iterator<Node> nodes() {
        return this.nodes.iterator();
    }

    public Iterator<Node> V(long ... lArray) {
        return this.nodes(lArray);
    }

    public final Node node(long l) {
        return this.nodes.nodeById(l);
    }

    public final Iterator<Node> nodes(long ... lArray) {
        if (lArray.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        if (lArray.length == 1) {
            return IteratorUtils.of((Object)this.node(lArray[0]));
        }
        HashSet<Long> hashSet = new HashSet<Long>(lArray.length);
        for (long l2 : lArray) {
            hashSet.add(l2);
        }
        return IteratorUtils.map(hashSet.iterator(), l -> this.node((long)l));
    }

    public Iterator<Node> nodes(String string) {
        return this.nodes.nodesByLabel(string).iterator();
    }

    public Iterator<Node> nodes(String ... stringArray) {
        MultiIterator multiIterator = new MultiIterator();
        for (String string : stringArray) {
            this.addNodesToMultiIterator((MultiIterator<Node>)multiIterator, string);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(Set<String> set) {
        MultiIterator multiIterator = new MultiIterator();
        for (String string : set) {
            this.addNodesToMultiIterator((MultiIterator<Node>)multiIterator, string);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(P<String> p) {
        MultiIterator multiIterator = new MultiIterator();
        for (String string : this.nodes.nodeLabels()) {
            if (!p.test((Object)string)) continue;
            this.addNodesToMultiIterator((MultiIterator<Node>)multiIterator, string);
        }
        return multiIterator;
    }

    private final void addNodesToMultiIterator(MultiIterator<Node> multiIterator, String string) {
        Set<Node> set = this.nodes.nodesByLabel(string);
        if (set != null) {
            multiIterator.addIterator(set.iterator());
        }
    }

    public Graph.Features features() {
        return this.features;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OdbStorage getStorage() {
        return this.storage;
    }

    public void copyTo(OdbGraph odbGraph) {
        if (odbGraph.nodeCount() > 0) {
            throw new AssertionError((Object)"destination graph must be empty, but isn't");
        }
        this.nodes().forEachRemaining(node -> odbGraph.addNode(node.id2(), node.label(), PropertyHelper.toKeyValueArray(node.propertyMap())));
        this.edges().forEachRemaining(odbEdge -> {
            Node node = odbGraph.node(odbEdge.inNode().id2());
            Node node2 = odbGraph.node(odbEdge.outNode().id2());
            node2.addEdge2(odbEdge.label(), node, PropertyHelper.toKeyValueArray(odbEdge.propertyMap()));
        });
    }

    public void remove(Node node) {
        this.nodes.remove(node);
        this.storage.removeNode(node.id2());
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(OdbGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{OdbGraphStepStrategy.instance(), CountStrategy.instance()}));
    }

    public class OdbVertexPropertyFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private OdbVertexPropertyFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object object) {
            return false;
        }
    }

    public class OdbGraphFeatures
    implements Graph.Features.GraphFeatures {
        private OdbGraphFeatures() {
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public class OdbEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private OdbEdgeFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object object) {
            return false;
        }
    }

    public class OdbVertexFeatures
    implements Graph.Features.VertexFeatures {
        private final OdbVertexPropertyFeatures vertexPropertyFeatures;

        private OdbVertexFeatures() {
            this.vertexPropertyFeatures = new OdbVertexPropertyFeatures();
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        public boolean supportsCustomIds() {
            return true;
        }

        public boolean willAllowId(Object object) {
            return object instanceof Number || object instanceof String;
        }

        public VertexProperty.Cardinality getCardinality(String string) {
            return VertexProperty.Cardinality.single;
        }
    }

    public class GraphFeatures
    implements Graph.Features {
        private final OdbGraphFeatures graphFeatures;
        private final OdbEdgeFeatures edgeFeatures;
        private final OdbVertexFeatures vertexFeatures;

        private GraphFeatures() {
            this.graphFeatures = new OdbGraphFeatures();
            this.edgeFeatures = new OdbEdgeFeatures();
            this.vertexFeatures = new OdbVertexFeatures();
        }

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

