/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.LongStream;
import org.h2.mvstore.MVMap;
import overflowdb.NodeRef;
import overflowdb.OdbGraph;
import overflowdb.storage.OdbStorage;

public final class OdbIndexManager {
    private final OdbGraph graph;
    protected Map<String, Map<Object, Set<NodeRef>>> indexes = new ConcurrentHashMap<String, Map<Object, Set<NodeRef>>>();
    protected Map<String, Boolean> dirtyFlags = new ConcurrentHashMap<String, Boolean>();

    public OdbIndexManager(OdbGraph odbGraph) {
        this.graph = odbGraph;
    }

    public final void createNodePropertyIndex(String string) {
        this.checkPropertyName(string);
        if (this.indexes.containsKey(string)) {
            return;
        }
        this.dirtyFlags.put(string, true);
        this.graph.nodes.iterator().forEachRemaining(node -> {
            Object p = node.property2(string);
            if (p != null) {
                this.put(string, p, (NodeRef)node);
            }
        });
    }

    public boolean isIndexed(String string) {
        return this.indexes.containsKey(string);
    }

    private void checkPropertyName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Illegal property name: " + string);
        }
    }

    public final void loadNodePropertyIndex(String string, Map<Object, long[]> map) {
        this.dirtyFlags.put(string, false);
        map.entrySet().parallelStream().forEach(entry -> LongStream.of((long[])entry.getValue()).forEach(l -> this.put(string, entry.getKey(), (NodeRef)this.graph.vertex(l))));
    }

    public void putIfIndexed(String string, Object object, NodeRef nodeRef) {
        this.dirtyFlags.put(string, true);
        if (this.indexes.containsKey(string)) {
            this.put(string, object, nodeRef);
        }
    }

    private final void put(String string, Object object, NodeRef nodeRef) {
        Set<NodeRef> set;
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null == map) {
            this.indexes.putIfAbsent(string, new ConcurrentHashMap());
            map = this.indexes.get(string);
        }
        if (null == (set = map.get(object))) {
            map.putIfAbsent(object, ConcurrentHashMap.newKeySet());
            set = map.get(object);
        }
        set.add(nodeRef);
    }

    public final void dropNodePropertyIndex(String string) {
        if (this.indexes.containsKey(string)) {
            this.indexes.remove(string).clear();
            this.dirtyFlags.remove(string);
        }
    }

    public final Set<String> getIndexedNodeProperties() {
        return this.indexes.keySet();
    }

    public final int getIndexedNodeCount(String string) {
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        return map == null ? 0 : map.values().stream().mapToInt(Set::size).sum();
    }

    public final List<NodeRef> lookup(String string, Object object) {
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null == map) {
            return Collections.emptyList();
        }
        Set<NodeRef> set = map.get(object);
        if (null == set) {
            return Collections.emptyList();
        }
        return new ArrayList<NodeRef>(set);
    }

    public final void remove(String string, Object object, NodeRef nodeRef) {
        Set<NodeRef> set;
        this.dirtyFlags.put(string, true);
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null != map && null != (set = map.get(object))) {
            set.remove(nodeRef);
            if (set.size() == 0) {
                map.remove(object);
            }
        }
    }

    public final void removeElement(NodeRef nodeRef) {
        for (String object : this.indexes.keySet()) {
            this.dirtyFlags.put(object, true);
        }
        for (Map map : this.indexes.values()) {
            for (Set set : map.values()) {
                set.remove(nodeRef);
            }
        }
    }

    public Map<Object, Set<NodeRef>> getIndexMap(String string) {
        return this.indexes.get(string);
    }

    public void initializeStoredIndices(OdbStorage odbStorage) {
        odbStorage.getIndexNames().stream().forEach(string -> this.loadIndex((String)string, odbStorage));
    }

    public void loadIndex(String string, OdbStorage odbStorage) {
        MVMap<Object, long[]> mVMap = odbStorage.openIndex(string);
        this.loadNodePropertyIndex(string, (Map<Object, long[]>)mVMap);
    }

    public void storeIndexes(OdbStorage odbStorage) {
        this.getIndexedNodeProperties().stream().forEach(string -> this.saveIndex(odbStorage, (String)string, this.getIndexMap((String)string)));
    }

    private void saveIndex(OdbStorage odbStorage, String string, Map<Object, Set<NodeRef>> map) {
        if (this.dirtyFlags.get(string).booleanValue()) {
            odbStorage.clearIndex(string);
            MVMap<Object, long[]> mVMap = odbStorage.openIndex(string);
            map.entrySet().parallelStream().forEach(entry -> {
                Object k = entry.getKey();
                Set set = (Set)entry.getValue();
                mVMap.put(k, (Object)set.stream().mapToLong(nodeRef -> nodeRef.id).toArray());
            });
            this.dirtyFlags.put(string, false);
        }
    }
}

