/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import overflowdb.Direction;
import overflowdb.DummyEdgeIterator;
import overflowdb.EdgeFactory;
import overflowdb.Node;
import overflowdb.NodeLayoutInformation;
import overflowdb.NodeRef;
import overflowdb.OdbEdge;
import overflowdb.OdbGraph;
import overflowdb.OdbNodeProperty;
import overflowdb.OdbProperty;
import overflowdb.tp3.Converters;
import overflowdb.util.ArrayOffsetIterator;
import overflowdb.util.MultiIterator2;
import overflowdb.util.PackedIntArray;
import overflowdb.util.PropertyHelper;

public abstract class OdbNode
implements Vertex,
Node {
    public final NodeRef ref;
    private Object[] adjacentNodesWithProperties = new Object[0];
    private PackedIntArray edgeOffsets;
    private boolean dirty;
    private static final String[] ALL_LABELS = new String[0];

    protected OdbNode(NodeRef nodeRef) {
        this.ref = nodeRef;
        nodeRef.setNode(this);
        if (nodeRef.graph != null) {
            nodeRef.graph.referenceManager.applyBackpressureMaybe();
        }
        this.edgeOffsets = PackedIntArray.create(this.layoutInformation().numberOfDifferentAdjacentTypes() * 2);
    }

    public abstract NodeLayoutInformation layoutInformation();

    protected <V> Iterator<VertexProperty<V>> specificProperties(String string) {
        Object object = this.specificProperty2(string);
        if (object != null) {
            return IteratorUtils.of(new OdbNodeProperty<Object>(this, string, object));
        }
        return Collections.emptyIterator();
    }

    protected abstract Object specificProperty2(String var1);

    public Object[] getAdjacentNodesWithProperties() {
        return this.adjacentNodesWithProperties;
    }

    public void setAdjacentNodesWithProperties(Object[] objectArray) {
        this.adjacentNodesWithProperties = objectArray;
    }

    public int[] getEdgeOffsets() {
        return this.edgeOffsets.toIntArray();
    }

    public PackedIntArray getEdgeOffsetsPackedArray() {
        return this.edgeOffsets;
    }

    public void setEdgeOffsets(int[] nArray) {
        this.edgeOffsets = PackedIntArray.of(nArray);
    }

    public abstract Map<String, Object> valueMap();

    public Graph graph() {
        return this.ref.graph;
    }

    @Override
    public OdbGraph graph2() {
        return this.ref.graph;
    }

    public Object id() {
        return this.ref.id;
    }

    @Override
    public long id2() {
        return this.ref.id;
    }

    @Override
    public String label() {
        return this.ref.label();
    }

    public Set<String> keys() {
        return this.layoutInformation().propertyKeys();
    }

    public <V> VertexProperty<V> property(String string) {
        return this.specificProperty(string);
    }

    protected <V> VertexProperty<V> specificProperty(String string) {
        Iterator<VertexProperty<V>> iterator = this.specificProperties(string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return VertexProperty.empty();
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... stringArray) {
        if (stringArray.length == 0) {
            return this.layoutInformation().propertyKeys().stream().flatMap(string -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.specificProperties((String)string), 16), false)).iterator();
        }
        if (stringArray.length == 1) {
            return this.specificProperties(stringArray[0]);
        }
        return Arrays.stream(stringArray).flatMap(string -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.specificProperties((String)string), 16), false)).iterator();
    }

    @Override
    public Map<String, Object> propertyMap() {
        Set<String> set = this.layoutInformation().propertyKeys();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(set.size());
        for (String string : set) {
            Object p = this.property2(string);
            if (p == null) continue;
            hashMap.put(string, p);
        }
        return hashMap;
    }

    @Override
    public <P> P property2(String string) {
        return (P)this.specificProperty2(string);
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String string, V v, Object ... objectArray) {
        ElementHelper.legalPropertyKeyValueArray((Object[])objectArray);
        ElementHelper.validateProperty((String)string, v);
        VertexProperty<V> vertexProperty = this.updateSpecificProperty(cardinality, string, v);
        this.ref.graph.indexManager.putIfIndexed(string, v, this.ref);
        this.markAsDirty();
        return vertexProperty;
    }

    @Override
    public <P> void setProperty(String string, P p) {
        this.property(VertexProperty.Cardinality.single, string, p, new Object[0]);
    }

    protected abstract <V> VertexProperty<V> updateSpecificProperty(VertexProperty.Cardinality var1, String var2, V var3);

    protected abstract void removeSpecificProperty(String var1);

    @Override
    public void remove() {
        ArrayList arrayList = new ArrayList();
        this.bothE().forEachRemaining(arrayList::add);
        for (Edge edge : arrayList) {
            if (((OdbEdge)edge).isRemoved()) continue;
            edge.remove();
        }
        this.ref.graph.remove(this);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public void markAsClean() {
        this.dirty = false;
    }

    public <V> Iterator<Property<V>> getEdgeProperties(Direction direction, OdbEdge odbEdge, int n, String ... stringArray) {
        ArrayList<Property<V>> arrayList = new ArrayList<Property<V>>();
        if (stringArray.length != 0) {
            for (String string : stringArray) {
                arrayList.add(this.getEdgeProperty(direction, odbEdge, n, string));
            }
        } else {
            for (String string : this.layoutInformation().edgePropertyKeys(odbEdge.label())) {
                arrayList.add(this.getEdgeProperty(direction, odbEdge, n, string));
            }
        }
        return arrayList.iterator();
    }

    public Map<String, Object> getEdgePropertyMap(Direction direction, OdbEdge odbEdge, int n) {
        Set<String> set = this.layoutInformation().edgePropertyKeys(odbEdge.label());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(set.size());
        for (String string : set) {
            Object p = this.getEdgeProperty2(direction, odbEdge, n, string);
            if (p == null) continue;
            hashMap.put(string, p);
        }
        return hashMap;
    }

    public <V> Property<V> getEdgeProperty(Direction direction, OdbEdge odbEdge, int n, String string) {
        Object p = this.getEdgeProperty2(direction, odbEdge, n, string);
        if (p == null) {
            return EmptyProperty.instance();
        }
        return new OdbProperty(string, p, (Element)odbEdge);
    }

    public <P> P getEdgeProperty2(Direction direction, OdbEdge odbEdge, int n, String string) {
        int n2 = this.getEdgePropertyIndex(direction, odbEdge.label(), string, n);
        if (n2 == -1) {
            return null;
        }
        return (P)this.adjacentNodesWithProperties[n2];
    }

    public <V> void setEdgeProperty(Direction direction, String string, String string2, V v, int n) {
        int n2 = this.getEdgePropertyIndex(direction, string, string2, n);
        if (n2 == -1) {
            throw new RuntimeException("Edge " + string + " does not support property `" + string2 + "`.");
        }
        this.adjacentNodesWithProperties[n2] = v;
        this.markAsDirty();
    }

    private int calcAdjacentNodeIndex(Direction direction, String string, int n) {
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.startIndex(n2);
        return n3 + n;
    }

    private int getEdgePropertyIndex(Direction direction, String string, String string2, int n) {
        int n2 = this.calcAdjacentNodeIndex(direction, string, n);
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.layoutInformation().getOffsetRelativeToAdjacentNodeRef(string, string2);
        if (n3 == -1) {
            return -1;
        }
        return n2 + n3;
    }

    @Override
    public OdbEdge addEdge2(String string, Node node, Object ... objectArray) {
        NodeRef nodeRef = (NodeRef)node;
        NodeRef nodeRef2 = this.ref;
        int n = this.storeAdjacentNode(Direction.OUT, string, nodeRef, objectArray);
        int n2 = super.storeAdjacentNode(Direction.IN, string, nodeRef2, objectArray);
        OdbEdge odbEdge = this.instantiateDummyEdge(string, nodeRef2, nodeRef);
        odbEdge.setOutBlockOffset(n);
        odbEdge.setInBlockOffset(n2);
        return odbEdge;
    }

    @Override
    public OdbEdge addEdge2(String string, Node node, Map<String, Object> map) {
        return this.addEdge2(string, node, PropertyHelper.toKeyValueArray(map));
    }

    @Override
    public void addEdgeSilent(String string, Node node, Object ... objectArray) {
        NodeRef nodeRef = (NodeRef)node;
        NodeRef nodeRef2 = this.ref;
        this.storeAdjacentNode(Direction.OUT, string, nodeRef, objectArray);
        super.storeAdjacentNode(Direction.IN, string, nodeRef2, objectArray);
    }

    @Override
    public void addEdgeSilent(String string, Node node, Map<String, Object> map) {
        this.addEdgeSilent(string, node, PropertyHelper.toKeyValueArray(map));
    }

    public Edge addEdge(String string, Vertex vertex, Object ... objectArray) {
        return this.addEdge2(string, (Node)vertex, objectArray);
    }

    public Iterator<Edge> edges(org.apache.tinkerpop.gremlin.structure.Direction direction, String ... stringArray) {
        Iterator<OdbEdge> iterator;
        Direction direction2 = Converters.fromTinker(direction);
        MultiIterator2<Edge> multiIterator2 = new MultiIterator2<Edge>();
        if (direction2 == Direction.IN || direction2 == Direction.BOTH) {
            for (String string : this.calcInLabels(stringArray)) {
                iterator = this.createDummyEdgeIterator(Direction.IN, string);
                multiIterator2.addIterator(iterator);
            }
        }
        if (direction2 == Direction.OUT || direction2 == Direction.BOTH) {
            for (String string : this.calcOutLabels(stringArray)) {
                iterator = this.createDummyEdgeIterator(Direction.OUT, string);
                multiIterator2.addIterator(iterator);
            }
        }
        return multiIterator2;
    }

    public Iterator<Vertex> vertices(org.apache.tinkerpop.gremlin.structure.Direction direction, String ... stringArray) {
        return this.nodes(Converters.fromTinker(direction), stringArray);
    }

    public Iterator<Vertex> nodes(Direction direction, String ... stringArray) {
        MultiIterator2<Vertex> multiIterator2 = new MultiIterator2<Vertex>();
        if (direction == Direction.IN || direction == Direction.BOTH) {
            for (String string : this.calcInLabels(stringArray)) {
                multiIterator2.addIterator(this.in(string));
            }
        }
        if (direction == Direction.OUT || direction == Direction.BOTH) {
            for (String string : this.calcOutLabels(stringArray)) {
                multiIterator2.addIterator(this.out(string));
            }
        }
        return multiIterator2;
    }

    @Override
    public Iterator<Node> out() {
        return this.createAdjacentNodeIterator(Direction.OUT, ALL_LABELS);
    }

    @Override
    public Iterator<Node> out(String ... stringArray) {
        return this.createAdjacentNodeIterator(Direction.OUT, stringArray);
    }

    @Override
    public Iterator<Node> in() {
        MultiIterator2<Node> multiIterator2 = new MultiIterator2<Node>();
        for (String string : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator2.addIterator(this.in(string));
        }
        return multiIterator2;
    }

    @Override
    public Iterator<Node> in(String ... stringArray) {
        return this.createAdjacentNodeIterator(Direction.IN, stringArray);
    }

    @Override
    public Iterator<Node> both() {
        MultiIterator2<Node> multiIterator2 = new MultiIterator2<Node>();
        multiIterator2.addIterator(this.out());
        multiIterator2.addIterator(this.in());
        return multiIterator2;
    }

    @Override
    public Iterator<Node> both(String ... stringArray) {
        MultiIterator2<Node> multiIterator2 = new MultiIterator2<Node>();
        multiIterator2.addIterator(this.out(stringArray));
        multiIterator2.addIterator(this.in(stringArray));
        return multiIterator2;
    }

    @Override
    public Iterator<OdbEdge> outE() {
        MultiIterator2<OdbEdge> multiIterator2 = new MultiIterator2<OdbEdge>();
        for (String string : this.layoutInformation().allowedOutEdgeLabels()) {
            multiIterator2.addIterator(this.outE(string));
        }
        return multiIterator2;
    }

    @Override
    public Iterator<OdbEdge> outE(String ... stringArray) {
        return this.createDummyEdgeIterator(Direction.OUT, stringArray);
    }

    @Override
    public Iterator<OdbEdge> inE() {
        MultiIterator2<OdbEdge> multiIterator2 = new MultiIterator2<OdbEdge>();
        for (String string : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator2.addIterator(this.inE(string));
        }
        return multiIterator2;
    }

    @Override
    public Iterator<OdbEdge> inE(String ... stringArray) {
        return this.createDummyEdgeIterator(Direction.IN, stringArray);
    }

    @Override
    public Iterator<OdbEdge> bothE() {
        MultiIterator2<OdbEdge> multiIterator2 = new MultiIterator2<OdbEdge>();
        multiIterator2.addIterator(this.outE());
        multiIterator2.addIterator(this.inE());
        return multiIterator2;
    }

    @Override
    public Iterator<OdbEdge> bothE(String ... stringArray) {
        MultiIterator2<OdbEdge> multiIterator2 = new MultiIterator2<OdbEdge>();
        multiIterator2.addIterator(this.outE(stringArray));
        multiIterator2.addIterator(this.inE(stringArray));
        return multiIterator2;
    }

    protected final int blockOffsetToOccurrence(Direction direction, String string, NodeRef nodeRef, int n) {
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(n2);
        int n4 = this.getStrideSize(string);
        int n5 = -1;
        for (int i = n3; i <= n3 + n; i += n4) {
            NodeRef nodeRef2 = (NodeRef)this.adjacentNodesWithProperties[i];
            if (nodeRef2 == null || !nodeRef2.id().equals(nodeRef.id())) continue;
            ++n5;
        }
        if (n5 == -1) {
            throw new RuntimeException("unable to calculate occurrenceCount");
        }
        return n5;
    }

    protected final int occurrenceToBlockOffset(Direction direction, String string, NodeRef nodeRef, int n) {
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(n2);
        int n4 = this.blockLength(n2);
        int n5 = this.getStrideSize(string);
        int n6 = 0;
        for (int i = n3; i < n3 + n4; i += n5) {
            NodeRef nodeRef2 = (NodeRef)this.adjacentNodesWithProperties[i];
            if (nodeRef2 == null || !nodeRef2.id().equals(nodeRef.id())) continue;
            if (n6 == n) {
                int n7 = i - n3;
                return n7;
            }
            ++n6;
        }
        throw new RuntimeException("Unable to find occurrence " + n + " of " + string + " edge to node " + nodeRef.id());
    }

    protected final synchronized void removeEdge(Direction direction, String string, int n) {
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(n2) + n;
        int n4 = this.getStrideSize(string);
        for (int i = n3; i < n3 + n4; ++i) {
            this.adjacentNodesWithProperties[i] = null;
        }
        this.markAsDirty();
    }

    private Iterator<OdbEdge> createDummyEdgeIterator(Direction direction, String ... stringArray) {
        if (stringArray.length == 1) {
            return this.createDummyEdgeIteratorForSingleLabel(direction, stringArray[0]);
        }
        String[] stringArray2 = stringArray.length == 0 ? this.allowedLabelsByDirection(direction) : stringArray;
        MultiIterator2<OdbEdge> multiIterator2 = new MultiIterator2<OdbEdge>();
        for (String string : stringArray2) {
            multiIterator2.addIterator(this.createDummyEdgeIteratorForSingleLabel(direction, string));
        }
        return multiIterator2;
    }

    private Iterator<OdbEdge> createDummyEdgeIteratorForSingleLabel(Direction direction, String string) {
        int n = this.getPositionInEdgeOffsets(direction, string);
        if (n != -1) {
            int n2 = this.startIndex(n);
            int n3 = this.blockLength(n);
            int n4 = this.getStrideSize(string);
            return new DummyEdgeIterator(this.adjacentNodesWithProperties, n2, n2 + n3, n4, direction, string, this.ref);
        }
        return Collections.emptyIterator();
    }

    private final Iterator<Node> createAdjacentNodeIterator(Direction direction, String ... stringArray) {
        if (stringArray.length == 1) {
            return this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, stringArray[0]));
        }
        String[] stringArray2 = stringArray.length == 0 ? this.allowedLabelsByDirection(direction) : stringArray;
        MultiIterator2<Node> multiIterator2 = new MultiIterator2<Node>();
        for (String string : stringArray2) {
            multiIterator2.addIterator(this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, string)));
        }
        return multiIterator2;
    }

    public final Iterator<Node> createAdjacentNodeIteratorByOffSet(int n) {
        if (n != -1) {
            int n2 = this.startIndex(n);
            int n3 = this.blockLength(n);
            int n4 = this.layoutInformation().getEdgePropertyCountByOffsetPos(n) + 1;
            return new ArrayOffsetIterator<Node>(this.adjacentNodesWithProperties, n2, n2 + n3, n4);
        }
        return Collections.emptyIterator();
    }

    private final String[] allowedLabelsByDirection(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return this.layoutInformation().allowedOutEdgeLabels();
        }
        if (direction.equals((Object)Direction.IN)) {
            return this.layoutInformation().allowedInEdgeLabels();
        }
        throw new NotImplementedException(direction.toString());
    }

    private int storeAdjacentNode(Direction direction, String string, NodeRef nodeRef, Object ... objectArray) {
        int n = this.storeAdjacentNode(direction, string, nodeRef);
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i].equals(T.id) || objectArray[i].equals(T.label)) continue;
            String string2 = (String)objectArray[i];
            Object object = objectArray[i + 1];
            this.setEdgeProperty(direction, string, string2, object, n);
        }
        this.markAsDirty();
        return n;
    }

    private final synchronized int storeAdjacentNode(Direction direction, String string, NodeRef nodeRef) {
        int n = this.getPositionInEdgeOffsets(direction, string);
        if (n == -1) {
            throw new RuntimeException("Edge of type " + string + " with direction " + (Object)((Object)direction) + " not supported by class " + this.getClass().getSimpleName());
        }
        int n2 = this.startIndex(n);
        int n3 = this.blockLength(n);
        int n4 = this.getStrideSize(string);
        int n5 = n2 + n3;
        if (this.adjacentNodesWithProperties.length <= n5 || this.adjacentNodesWithProperties[n5] != null) {
            this.adjacentNodesWithProperties = this.growAdjacentNodesWithProperties(n, n4, n5, n3);
        }
        this.adjacentNodesWithProperties[n5] = nodeRef;
        this.edgeOffsets.set(2 * n + 1, n3 + n4);
        int n6 = n3;
        return n6;
    }

    private int startIndex(int n) {
        return this.edgeOffsets.get(2 * n);
    }

    private final int getStrideSize(String string) {
        int n = 1;
        Set<String> set = this.layoutInformation().edgePropertyKeys(string);
        return n + set.size();
    }

    private final int getPositionInEdgeOffsets(Direction direction, String string) {
        Integer n = direction == Direction.OUT ? this.layoutInformation().outEdgeToOffsetPosition(string) : this.layoutInformation().inEdgeToOffsetPosition(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    private final int blockLength(int n) {
        return this.edgeOffsets.get(2 * n + 1);
    }

    private final String[] calcInLabels(String ... stringArray) {
        if (stringArray.length != 0) {
            return stringArray;
        }
        return this.layoutInformation().allowedInEdgeLabels();
    }

    private final String[] calcOutLabels(String ... stringArray) {
        if (stringArray.length != 0) {
            return stringArray;
        }
        return this.layoutInformation().allowedOutEdgeLabels();
    }

    private final synchronized Object[] growAdjacentNodesWithProperties(int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = (n4 + n2) * n5;
        int n7 = this.adjacentNodesWithProperties.length + n6;
        Object[] objectArray = new Object[n7];
        System.arraycopy(this.adjacentNodesWithProperties, 0, objectArray, 0, n3);
        System.arraycopy(this.adjacentNodesWithProperties, n3, objectArray, n3 + n6, this.adjacentNodesWithProperties.length - n3);
        int n8 = n + 1;
        while (2 * n8 < this.edgeOffsets.length()) {
            this.edgeOffsets.set(2 * n8, this.edgeOffsets.get(2 * n8) + n6);
            ++n8;
        }
        return objectArray;
    }

    protected final OdbEdge instantiateDummyEdge(String string, NodeRef nodeRef, NodeRef nodeRef2) {
        EdgeFactory edgeFactory = this.ref.graph.edgeFactoryByLabel.get(string);
        if (edgeFactory == null) {
            throw new IllegalArgumentException("specializedEdgeFactory for label=" + string + " not found - please register on startup!");
        }
        return edgeFactory.createEdge(this.ref.graph, nodeRef, nodeRef2);
    }

    public synchronized long trim() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (2 * n3 < this.edgeOffsets.length()) {
            n = this.blockLength(n3);
            n2 += n;
            ++n3;
        }
        Object[] objectArray = new Object[n2];
        n = 0;
        int n4 = 0;
        while (2 * n4 < this.edgeOffsets.length()) {
            int n5 = this.startIndex(n4);
            int n6 = this.blockLength(n4);
            System.arraycopy(this.adjacentNodesWithProperties, n5, objectArray, n, n6);
            this.edgeOffsets.set(2 * n4, n);
            n += n6;
            ++n4;
        }
        n4 = this.adjacentNodesWithProperties.length;
        this.adjacentNodesWithProperties = objectArray;
        return (long)n2 + ((long)n4 << 32);
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public int hashCode() {
        return Objects.hash(this.id2());
    }

    public boolean equals(Object object) {
        return object instanceof OdbNode && this.id2() == ((OdbNode)object).id2();
    }
}

