/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.HeapUsageMonitor;
import overflowdb.NodeRef;
import overflowdb.storage.OdbStorage;
import overflowdb.util.NamedThreadFactory;

public class ReferenceManager
implements AutoCloseable,
HeapUsageMonitor.HeapNotificationListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public final int releaseCount = 100000;
    private AtomicInteger totalReleaseCount = new AtomicInteger(0);
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("overflowdb-reference-manager"));
    private int clearingProcessCount = 0;
    private final Object backPressureSyncObject = new Object();
    private final OdbStorage storage;
    private final List<NodeRef> clearableRefs = Collections.synchronizedList(new LinkedList());

    public ReferenceManager(OdbStorage odbStorage) {
        this.storage = odbStorage;
    }

    public void registerRef(NodeRef nodeRef) {
        this.clearableRefs.add(nodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyBackpressureMaybe() {
        Object object = this.backPressureSyncObject;
        synchronized (object) {
            while (this.clearingProcessCount > 0) {
                try {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("wait until ref clearing completed");
                    }
                    this.backPressureSyncObject.wait();
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("continue");
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            return;
        }
    }

    @Override
    public void notifyHeapAboveThreshold() {
        if (this.clearingProcessCount > 0) {
            this.logger.debug("cleaning in progress, will only queue up more references to clear after that's completed");
        } else if (this.clearableRefs.isEmpty()) {
            this.logger.info("no refs to clear at the moment, i.e. the heap is used by other components");
        } else {
            int n = Integer.min(this.releaseCount, this.clearableRefs.size());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("scheduled to clear " + n + " references (asynchronously)");
            }
            this.singleThreadExecutor.submit(() -> this.syncClearReferences(n));
        }
    }

    private void syncClearReferences(int n) {
        List<NodeRef> list = this.collectRefsToClear(n);
        if (!list.isEmpty()) {
            this.safelyClearReferences(list);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("completed clearing of " + list.size() + " references");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("current clearable queue size: " + this.clearableRefs.size());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("references cleared in total: " + this.totalReleaseCount);
            }
        }
    }

    private List<NodeRef> collectRefsToClear(int n) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(n);
        while (n > 0 && !this.clearableRefs.isEmpty()) {
            NodeRef nodeRef = this.clearableRefs.remove(0);
            if (nodeRef != null) {
                arrayList.add(nodeRef);
            }
            --n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyClearReferences(List<NodeRef> list) {
        try {
            Object object = this.backPressureSyncObject;
            synchronized (object) {
                ++this.clearingProcessCount;
            }
            this.clearReferences(list);
            this.storage.flush();
        }
        catch (Exception exception) {
            this.logger.error("error while trying to clear references", (Throwable)exception);
        }
        finally {
            Object object = this.backPressureSyncObject;
            synchronized (object) {
                --this.clearingProcessCount;
                if (this.clearingProcessCount == 0) {
                    this.backPressureSyncObject.notifyAll();
                }
            }
        }
    }

    private void clearReferences(List<NodeRef> list) {
        ((Stream)this.serializeReferences(list.parallelStream().filter(NodeRef::isSet)).sequential()).forEach(serializedNode -> {
            serializedNode.ref.persist(serializedNode.data);
            serializedNode.ref.clear();
            this.totalReleaseCount.incrementAndGet();
        });
    }

    private Stream<SerializedNode> serializeReferences(Stream<NodeRef> stream) {
        return stream.map(ReferenceManager::serializeReference).filter(Objects::nonNull);
    }

    private static SerializedNode serializeReference(NodeRef nodeRef) {
        byte[] byArray = nodeRef.serializeWhenDirty();
        if (byArray != null) {
            return new SerializedNode(nodeRef, byArray);
        }
        return null;
    }

    public void clearAllReferences() {
        while (!this.clearableRefs.isEmpty()) {
            int n = this.clearableRefs.size();
            this.logger.info("clearing all (" + n + ") references - this may take some time");
            try {
                this.syncClearReferences(n);
            }
            catch (Exception exception) {
                throw new RuntimeException("error while clearing references to disk", exception);
            }
        }
        this.logger.info("cleared all clearable references");
    }

    @Override
    public void close() {
        this.singleThreadExecutor.shutdown();
    }

    private static class SerializedNode {
        public final NodeRef ref;
        public final byte[] data;

        public SerializedNode(NodeRef nodeRef, byte[] byArray) {
            this.ref = nodeRef;
            this.data = byArray;
        }
    }
}

