/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.OdbGraph;
import overflowdb.OdbNode;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.ValueTypes;

public class NodeDeserializer
extends BookKeeper {
    protected final OdbGraph graph;
    private final Map<Integer, NodeFactory> nodeFactoryByLabelId;
    private ConcurrentHashMap<String, String> interner;

    public NodeDeserializer(OdbGraph odbGraph, Map<Integer, NodeFactory> map, boolean bl) {
        super(bl);
        this.graph = odbGraph;
        this.nodeFactoryByLabelId = map;
        this.interner = new ConcurrentHashMap();
    }

    private final String intern(String string) {
        String string2 = this.interner.putIfAbsent(string, string);
        return string2 == null ? string : string2;
    }

    public final OdbNode deserialize(byte[] byArray) throws IOException {
        long l = this.getStartTimeNanos();
        if (null == byArray) {
            return null;
        }
        MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((byte[])byArray);
        long l2 = messageUnpacker.unpackLong();
        int n = messageUnpacker.unpackInt();
        Map<String, Object> map = this.unpackProperties(messageUnpacker);
        int[] nArray = this.unpackEdgeOffsets(messageUnpacker);
        Object[] objectArray = this.unpackAdjacentNodesWithProperties(messageUnpacker);
        OdbNode odbNode = this.createNode(l2, n, map, nArray, objectArray);
        if (this.statsEnabled) {
            this.recordStatistics(l);
        }
        return odbNode;
    }

    public final NodeRef deserializeRef(byte[] byArray) throws IOException {
        try (MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((byte[])byArray);){
            long l = messageUnpacker.unpackLong();
            int n = messageUnpacker.unpackInt();
            NodeRef nodeRef = this.createNodeRef(l, n);
            return nodeRef;
        }
    }

    private final Map<String, Object> unpackProperties(MessageUnpacker messageUnpacker) throws IOException {
        int n = messageUnpacker.unpackMapHeader();
        THashMap tHashMap = new THashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = this.intern(messageUnpacker.unpackString());
            Object object = this.unpackValue((ArrayValue)messageUnpacker.unpackValue().asArrayValue());
            tHashMap.put(string, object);
        }
        return tHashMap;
    }

    private final int[] unpackEdgeOffsets(MessageUnpacker messageUnpacker) throws IOException {
        int n = messageUnpacker.unpackArrayHeader();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = messageUnpacker.unpackInt();
        }
        return nArray;
    }

    protected final Object[] unpackAdjacentNodesWithProperties(MessageUnpacker messageUnpacker) throws IOException {
        int n = messageUnpacker.unpackArrayHeader();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.unpackValue((ArrayValue)messageUnpacker.unpackValue().asArrayValue());
        }
        return objectArray;
    }

    private final Object unpackValue(ArrayValue arrayValue) {
        Iterator iterator = arrayValue.iterator();
        byte by = ((Value)iterator.next()).asIntegerValue().asByte();
        Value value = (Value)iterator.next();
        switch (ValueTypes.lookup(by)) {
            case UNKNOWN: {
                return null;
            }
            case NODE_REF: {
                long l = value.asIntegerValue().asLong();
                return this.graph.vertex(l);
            }
            case BOOLEAN: {
                return value.asBooleanValue().getBoolean();
            }
            case STRING: {
                return this.intern(value.asStringValue().asString());
            }
            case BYTE: {
                return value.asIntegerValue().asByte();
            }
            case SHORT: {
                return value.asIntegerValue().asShort();
            }
            case INTEGER: {
                return value.asIntegerValue().asInt();
            }
            case LONG: {
                return value.asIntegerValue().asLong();
            }
            case FLOAT: {
                return Float.valueOf(value.asFloatValue().toFloat());
            }
            case DOUBLE: {
                return (double)value.asFloatValue().toFloat();
            }
            case LIST: {
                ArrayValue arrayValue2 = value.asArrayValue();
                ArrayList<Object> arrayList = new ArrayList<Object>(arrayValue2.size());
                Iterator iterator2 = arrayValue2.iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(this.unpackValue(((Value)iterator2.next()).asArrayValue()));
                }
                return arrayList;
            }
            case CHARACTER: {
                return Character.valueOf((char)value.asIntegerValue().asInt());
            }
        }
        throw new NotImplementedException("unknown valueTypeId=`" + by);
    }

    protected final Object[] toTinkerpopKeyValues(Map<String, Object> map) {
        ArrayList<Object> arrayList = new ArrayList<Object>(map.size() * 2);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = this.intern(entry.getKey());
            Object object = entry.getValue();
            arrayList.add(string);
            if (object instanceof String) {
                arrayList.add(this.intern((String)object));
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    protected final NodeRef createNodeRef(long l, int n) {
        return this.getNodeFactory(n).createNodeRef(this.graph, l);
    }

    protected final OdbNode createNode(long l, int n, Map<String, Object> map, int[] nArray, Object[] objectArray) {
        Object v = this.getNodeFactory(n).createNode(this.graph, l);
        ElementHelper.attachProperties(v, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])this.toTinkerpopKeyValues(map));
        ((OdbNode)v).setEdgeOffsets(nArray);
        ((OdbNode)v).setAdjacentNodesWithProperties(objectArray);
        ((OdbNode)v).markAsClean();
        return v;
    }

    private final NodeFactory getNodeFactory(int n) {
        if (!this.nodeFactoryByLabelId.containsKey(n)) {
            throw new AssertionError((Object)("nodeFactory not found for labelId=" + n));
        }
        return this.nodeFactoryByLabelId.get(n);
    }
}

