/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import overflowdb.NodeRef;
import overflowdb.OdbNode;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.ValueTypes;
import overflowdb.util.PackedIntArray;

public class NodeSerializer
extends BookKeeper {
    public NodeSerializer(boolean bl) {
        super(bl);
    }

    public byte[] serialize(OdbNode odbNode) throws IOException {
        long l = this.getStartTimeNanos();
        try (MessageBufferPacker messageBufferPacker = MessagePack.newDefaultBufferPacker();){
            odbNode.markAsClean();
            messageBufferPacker.packLong(odbNode.ref.id);
            messageBufferPacker.packInt(odbNode.layoutInformation().labelId);
            this.packProperties(messageBufferPacker, odbNode.valueMap());
            this.packEdgeOffsets(messageBufferPacker, odbNode.getEdgeOffsetsPackedArray());
            this.packAdjacentNodesWithProperties(messageBufferPacker, odbNode.getAdjacentNodesWithProperties());
            if (this.statsEnabled) {
                this.recordStatistics(l);
            }
            byte[] byArray = messageBufferPacker.toByteArray();
            return byArray;
        }
    }

    private void packProperties(MessageBufferPacker messageBufferPacker, Map<String, Object> map) throws IOException {
        messageBufferPacker.packMapHeader(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            messageBufferPacker.packString(entry.getKey());
            this.packTypedValue(messageBufferPacker, entry.getValue());
        }
    }

    private void packEdgeOffsets(MessageBufferPacker messageBufferPacker, PackedIntArray packedIntArray) throws IOException {
        messageBufferPacker.packArrayHeader(packedIntArray.length());
        for (int i = 0; i < packedIntArray.length(); ++i) {
            messageBufferPacker.packInt(packedIntArray.get(i));
        }
    }

    private void packAdjacentNodesWithProperties(MessageBufferPacker messageBufferPacker, Object[] objectArray) throws IOException {
        messageBufferPacker.packArrayHeader(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.packTypedValue(messageBufferPacker, objectArray[i]);
        }
    }

    private void packTypedValue(MessageBufferPacker messageBufferPacker, Object object) throws IOException {
        messageBufferPacker.packArrayHeader(2);
        if (object == null) {
            messageBufferPacker.packByte(ValueTypes.UNKNOWN.id);
            messageBufferPacker.packNil();
        } else if (object instanceof NodeRef) {
            messageBufferPacker.packByte(ValueTypes.NODE_REF.id);
            messageBufferPacker.packLong(((NodeRef)object).id);
        } else if (object instanceof Boolean) {
            messageBufferPacker.packByte(ValueTypes.BOOLEAN.id);
            messageBufferPacker.packBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof String) {
            messageBufferPacker.packByte(ValueTypes.STRING.id);
            messageBufferPacker.packString((String)object);
        } else if (object instanceof Byte) {
            messageBufferPacker.packByte(ValueTypes.BYTE.id);
            messageBufferPacker.packByte(((Byte)object).byteValue());
        } else if (object instanceof Short) {
            messageBufferPacker.packByte(ValueTypes.SHORT.id);
            messageBufferPacker.packShort(((Short)object).shortValue());
        } else if (object instanceof Integer) {
            messageBufferPacker.packByte(ValueTypes.INTEGER.id);
            messageBufferPacker.packInt(((Integer)object).intValue());
        } else if (object instanceof Long) {
            messageBufferPacker.packByte(ValueTypes.LONG.id);
            messageBufferPacker.packLong(((Long)object).longValue());
        } else if (object instanceof Float) {
            messageBufferPacker.packByte(ValueTypes.FLOAT.id);
            messageBufferPacker.packFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            messageBufferPacker.packByte(ValueTypes.DOUBLE.id);
            messageBufferPacker.packFloat(((Float)object).floatValue());
        } else if (object instanceof List) {
            messageBufferPacker.packByte(ValueTypes.LIST.id);
            List list = (List)object;
            messageBufferPacker.packArrayHeader(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.packTypedValue(messageBufferPacker, iterator.next());
            }
        } else if (object instanceof Character) {
            messageBufferPacker.packByte(ValueTypes.CHARACTER.id);
            messageBufferPacker.packInt((int)((Character)object).charValue());
        } else {
            throw new NotImplementedException("id type `" + object.getClass() + "` not yet supported");
        }
    }
}

