/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.OdbNode;
import overflowdb.storage.NodeDeserializer;
import overflowdb.storage.NodeSerializer;

public class OdbStorage
implements AutoCloseable {
    private static final String INDEX_PREFIX = "index_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final NodeSerializer nodeSerializer;
    protected final Optional<NodeDeserializer> nodeDeserializer;
    private final File mvstoreFile;
    private final boolean doPersist;
    private MVStore mvstore;
    private MVMap<Long, byte[]> nodesMVMap;
    private boolean closed;

    public static OdbStorage createWithTempFile(NodeDeserializer nodeDeserializer, boolean bl) {
        return new OdbStorage(Optional.empty(), Optional.ofNullable(nodeDeserializer), bl);
    }

    public static OdbStorage createWithSpecificLocation(NodeDeserializer nodeDeserializer, File file, boolean bl) {
        return new OdbStorage(Optional.ofNullable(file), Optional.ofNullable(nodeDeserializer), bl);
    }

    public static OdbStorage createWithSpecificLocation(File file, boolean bl) {
        return new OdbStorage(Optional.ofNullable(file), Optional.empty(), bl);
    }

    private OdbStorage(Optional<File> optional, Optional<NodeDeserializer> optional2, boolean bl) {
        this.nodeSerializer = new NodeSerializer(bl);
        this.nodeDeserializer = optional2;
        if (optional.isPresent()) {
            this.doPersist = true;
            this.mvstoreFile = optional.get();
        } else {
            try {
                this.doPersist = false;
                this.mvstoreFile = File.createTempFile("mvstore", ".bin");
                this.mvstoreFile.deleteOnExit();
            }
            catch (IOException iOException) {
                throw new RuntimeException("cannot create tmp file for mvstore", iOException);
            }
        }
        this.logger.trace("storage file: " + this.mvstoreFile);
    }

    public void persist(OdbNode odbNode) {
        long l = odbNode.ref.id;
        this.persist(l, this.serialize(odbNode));
    }

    public byte[] serialize(OdbNode odbNode) {
        try {
            return this.nodeSerializer.serialize(odbNode);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void persist(long l, byte[] byArray) {
        if (!this.closed) {
            this.getNodesMVMap().put((Object)l, (Object)byArray);
        }
    }

    public <A extends Vertex> A readNode(long l) throws IOException {
        return (A)this.nodeDeserializer.get().deserialize((byte[])this.getNodesMVMap().get((Object)l));
    }

    public void flush() {
        if (this.mvstore != null) {
            this.logger.debug("flushing to disk");
            this.mvstore.commit();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.logger.info("closing " + this.getClass().getSimpleName());
        this.flush();
        if (this.mvstore != null) {
            this.mvstore.close();
        }
        if (!this.doPersist) {
            this.mvstoreFile.delete();
        }
    }

    public File getStorageFile() {
        return this.mvstoreFile;
    }

    public void removeNode(Long l) {
        this.getNodesMVMap().remove((Object)l);
    }

    public Set<Map.Entry<Long, byte[]>> allNodes() {
        return this.getNodesMVMap().entrySet();
    }

    public NodeSerializer getNodeSerializer() {
        return this.nodeSerializer;
    }

    public MVMap<Long, byte[]> getNodesMVMap() {
        if (this.mvstore == null) {
            this.mvstore = this.initializeMVStore();
        }
        if (this.nodesMVMap == null) {
            this.nodesMVMap = this.mvstore.openMap("nodes");
        }
        return this.nodesMVMap;
    }

    private MVStore initializeMVStore() {
        MVStore mVStore = new MVStore.Builder().fileName(this.mvstoreFile.getAbsolutePath()).autoCommitBufferSize(8192).open();
        return mVStore;
    }

    public Optional<NodeDeserializer> getNodeDeserializer() {
        return this.nodeDeserializer;
    }

    private Map<String, String> getIndexNameMap(MVStore mVStore) {
        return mVStore.getMapNames().stream().filter(string -> string.startsWith(INDEX_PREFIX)).collect(Collectors.toConcurrentMap(string -> this.removeIndexPrefix((String)string), string -> string));
    }

    public Set<String> getIndexNames() {
        return this.getIndexNameMap(this.mvstore).keySet();
    }

    private String removeIndexPrefix(String string) {
        assert (string.startsWith(INDEX_PREFIX));
        return string.substring(INDEX_PREFIX.length());
    }

    public MVMap<Object, long[]> openIndex(String string) {
        String string2 = this.getIndexMapName(string);
        return this.mvstore.openMap(string2);
    }

    private String getIndexMapName(String string) {
        return INDEX_PREFIX + string;
    }

    public void clearIndices() {
        this.getIndexNames().forEach(this::clearIndex);
    }

    public void clearIndex(String string) {
        this.openIndex(string).clear();
    }
}

