/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.tp3.optimizations;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.CollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import overflowdb.tp3.optimizations.OdbCountStep;
import overflowdb.tp3.optimizations.OdbGraphStepStrategy;

public final class CountStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final CountStrategy INSTANCE = new CountStrategy();

    private CountStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> admin) {
        if (!(admin.getParent() instanceof EmptyStep) || TraversalHelper.onGraphComputer(admin)) {
            return;
        }
        List list = admin.getSteps();
        if (list.size() < 2 || !(list.get(0) instanceof GraphStep) || 0 != ((GraphStep)list.get(0)).getIds().length || !(list.get(list.size() - 1) instanceof CountGlobalStep)) {
            return;
        }
        for (int i = 1; i < list.size() - 1; ++i) {
            Step step2 = (Step)list.get(i);
            if ((step2 instanceof IdentityStep || step2 instanceof NoOpBarrierStep || step2 instanceof CollectingBarrierStep) && (!(step2 instanceof TraversalParent) || !TraversalHelper.anyStepRecursively(step -> step instanceof SideEffectStep || step instanceof AggregateStep, (TraversalParent)((TraversalParent)step2)))) continue;
            return;
        }
        Class clazz = ((GraphStep)list.get(0)).getReturnClass();
        TraversalHelper.removeAllSteps(admin);
        admin.addStep(new OdbCountStep(admin, clazz));
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        return Collections.singleton(OdbGraphStepStrategy.class);
    }

    public static CountStrategy instance() {
        return INSTANCE;
    }
}

