/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.tp3.optimizations;

import java.util.NoSuchElementException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import overflowdb.OdbGraph;

public final class OdbCountStep<S extends Element>
extends AbstractStep<S, Long> {
    private final Class<S> elementClass;
    private boolean done = false;

    public OdbCountStep(Traversal.Admin admin, Class<S> clazz) {
        super(admin);
        this.elementClass = clazz;
    }

    protected Traverser.Admin<Long> processNextStart() throws NoSuchElementException {
        if (!this.done) {
            this.done = true;
            OdbGraph odbGraph = (OdbGraph)this.getTraversal().getGraph().get();
            if (!Vertex.class.isAssignableFrom(this.elementClass)) {
                throw new NotImplementedException("edges only exist virtually. run e.g. `g.V().outE().count()` instead");
            }
            long l = odbGraph.nodeCount();
            return this.getTraversal().getTraverserGenerator().generate((Object)l, (Step)this, 1L);
        }
        throw FastNoSuchElementException.instance();
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.elementClass.getSimpleName().toLowerCase()});
    }

    public int hashCode() {
        return super.hashCode() ^ this.elementClass.hashCode();
    }

    public void reset() {
        this.done = false;
    }
}

