/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.tp3.optimizations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import overflowdb.OdbGraph;

public final class OdbGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public OdbGraphStep(GraphStep<S, E> graphStep) {
        super(graphStep.getTraversal(), graphStep.getReturnClass(), graphStep.isStartStep(), graphStep.getIds());
        graphStep.getLabels().forEach(arg_0 -> ((OdbGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        OdbGraph odbGraph = (OdbGraph)this.getTraversal().getGraph().get();
        Optional<HasContainer> optional = this.findHasLabelStep();
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        if (this.ids.length > 0) {
            return this.iteratorList(odbGraph.edges(this.ids));
        }
        return this.iteratorList(odbGraph.edges());
    }

    private Iterator<? extends Vertex> vertices() {
        OdbGraph odbGraph = (OdbGraph)this.getTraversal().getGraph().get();
        HasContainer hasContainer = this.getIndexKey();
        Optional<HasContainer> optional = this.findHasLabelStep();
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        if (this.ids.length > 0) {
            return this.iteratorList(odbGraph.vertices(this.ids));
        }
        if (optional.isPresent()) {
            P p = optional.get().getPredicate();
            return odbGraph.nodes((P<String>)p);
        }
        if (hasContainer == null) {
            return this.iteratorList(odbGraph.vertices(new Object[0]));
        }
        return IteratorUtils.filter(odbGraph.indexManager.lookup(hasContainer.getKey(), hasContainer.getPredicate().getValue()).iterator(), nodeRef -> HasContainer.testAll((Element)nodeRef, this.hasContainers));
    }

    private Optional<HasContainer> findHasLabelStep() {
        if (this.hasContainers.size() == 1 && T.label.getAccessor().equals(this.hasContainers.get(0).getKey())) {
            return Optional.of(this.hasContainers.get(0));
        }
        return Optional.empty();
    }

    private HasContainer getIndexKey() {
        OdbGraph odbGraph = (OdbGraph)this.getTraversal().getGraph().get();
        Set<String> set = odbGraph.indexManager.getIndexedNodeProperties();
        Iterator iterator = IteratorUtils.filter(this.hasContainers.iterator(), hasContainer -> hasContainer.getPredicate().getBiPredicate() == Compare.eq && set.contains(hasContainer.getKey()));
        return iterator.hasNext() ? (HasContainer)iterator.next() : null;
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    private <E extends Element> Iterator<E> iteratorList(Iterator<E> iterator) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!HasContainer.testAll((Element)element, this.hasContainers)) continue;
            arrayList.add(element);
        }
        return arrayList.iterator();
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P p : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), p));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.hasContainers.hashCode();
    }
}

