/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.tp3.optimizations;

import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import overflowdb.tp3.optimizations.OdbGraphStep;

public final class OdbGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final OdbGraphStepStrategy INSTANCE = new OdbGraphStepStrategy();

    private OdbGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> admin) {
        if (TraversalHelper.onGraphComputer(admin)) {
            return;
        }
        for (GraphStep graphStep : TraversalHelper.getStepsOfClass(GraphStep.class, admin)) {
            OdbGraphStep odbGraphStep = new OdbGraphStep(graphStep);
            TraversalHelper.replaceStep((Step)graphStep, odbGraphStep, admin);
            Step step = odbGraphStep.getNextStep();
            while (step instanceof HasStep || step instanceof NoOpBarrierStep) {
                if (step instanceof HasStep) {
                    for (HasContainer hasContainer : ((HasContainerHolder)step).getHasContainers()) {
                        if (GraphStep.processHasContainerIds(odbGraphStep, (HasContainer)hasContainer)) continue;
                        odbGraphStep.addHasContainer(hasContainer);
                    }
                    TraversalHelper.copyLabels((Step)step, (Step)step.getPreviousStep(), (boolean)false);
                    admin.removeStep(step);
                }
                step = step.getNextStep();
            }
        }
    }

    public static OdbGraphStepStrategy instance() {
        return INSTANCE;
    }
}

