/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayOffsetIterator<T>
implements Iterator<T> {
    private final Object[] array;
    private int current;
    private final int exclusiveEnd;
    private final int strideSize;
    private T nextCached;

    public ArrayOffsetIterator(Object[] objectArray, int n, int n2, int n3) {
        this.array = objectArray;
        this.current = n;
        this.exclusiveEnd = n2;
        this.strideSize = n3;
    }

    @Override
    public final boolean hasNext() {
        return this.peekNext() != null;
    }

    private T peekNext() {
        if (this.nextCached != null) {
            return this.nextCached;
        }
        if (this.current < this.exclusiveEnd) {
            this.nextCached = this.array[this.current];
            this.current += this.strideSize;
            return this.peekNext();
        }
        return null;
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            T t = this.peekNext();
            this.nextCached = null;
            return t;
        }
        throw new NoSuchElementException();
    }
}

