/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import overflowdb.Node;
import overflowdb.NodeRef;
import overflowdb.OdbNode;

public class NodesList {
    private Node[] nodes;
    private int size = 0;
    private TLongIntMap nodeIndexByNodeId;
    private TMap<String, Set<Node>> nodesByLabel;
    private final BitSet emptySlots;
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public NodesList() {
        this(10000);
    }

    public NodesList(int n) {
        this.nodes = new Node[n];
        this.emptySlots = new BitSet(n);
        this.nodeIndexByNodeId = new TLongIntHashMap(n);
        this.nodesByLabel = new THashMap(10);
    }

    public synchronized void add(Node node) {
        this.verifyUniqueId(node);
        int n = this.tryClaimEmptySlot();
        if (n == -1) {
            n = this.size;
            this.ensureCapacity(this.size + 1);
        }
        this.nodes[n] = node;
        this.nodeIndexByNodeId.put(node.id2(), n);
        this.nodesByLabel(node.label()).add(node);
        ++this.size;
    }

    private void verifyUniqueId(Node node) {
        if (this.nodeIndexByNodeId.containsKey(node.id2())) {
            Node node2 = this.nodeById(node.id2());
            throw new AssertionError((Object)("different Node with same id already exists in this NodesList: " + node2));
        }
    }

    private int tryClaimEmptySlot() {
        int n = this.emptySlots.nextSetBit(0);
        if (n != -1) {
            this.emptySlots.clear(n);
        }
        return n;
    }

    public boolean contains(long l) {
        return this.nodeIndexByNodeId.containsKey(l);
    }

    public Node nodeById(long l) {
        if (this.nodeIndexByNodeId.containsKey(l)) {
            return this.nodes[this.nodeIndexByNodeId.get(l)];
        }
        return null;
    }

    public void remove(Node node) {
        int n = this.nodeIndexByNodeId.remove(node.id2());
        this.nodes[n] = null;
        this.emptySlots.set(n);
        NodeRef nodeRef = node instanceof OdbNode ? ((OdbNode)node).ref : (NodeRef)node;
        ((Set)this.nodesByLabel.get((Object)node.label())).remove(nodeRef);
        --this.size;
        this.compactMaybe();
    }

    public int size() {
        return this.size;
    }

    public Set<Node> nodesByLabel(String string) {
        if (!this.nodesByLabel.containsKey((Object)string)) {
            this.nodesByLabel.put((Object)string, (Object)new THashSet(10));
        }
        return (Set)this.nodesByLabel.get((Object)string);
    }

    public Set<String> nodeLabels() {
        HashSet<String> hashSet = new HashSet<String>(this.nodesByLabel.size());
        this.nodesByLabel.entrySet().forEach(entry -> {
            if (!((Set)entry.getValue()).isEmpty()) {
                hashSet.add((String)entry.getKey());
            }
        });
        return hashSet;
    }

    public Iterator<Node> iterator() {
        return new NodesIterator(Arrays.copyOf(this.nodes, this.nodes.length));
    }

    private void ensureCapacity(int n) {
        if (this.nodes.length < n) {
            this.grow(n);
        }
    }

    private void compactMaybe() {
        int n = this.emptySlots.cardinality();
        if (n > 10000 && n * 100 / this.nodes.length >= 30) {
            this.compact();
        }
    }

    public void compact() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.size);
        Iterator<Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.nodes = arrayList.toArray(new Node[this.size]);
        this.emptySlots.clear();
        this.nodeIndexByNodeId = new TLongIntHashMap(this.nodes.length);
        this.nodesByLabel = new THashMap(10);
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            this.nodeIndexByNodeId.put(node.id2(), i);
            this.nodesByLabel(node.label()).add(node);
        }
    }

    private void grow(int n) {
        int n2 = this.nodes.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = NodesList.hugeCapacity(n);
        }
        this.nodes = Arrays.copyOf(this.nodes, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    protected int _elementDataSize() {
        return this.nodes.length;
    }

    public int cardinality(String string) {
        if (this.nodesByLabel.containsKey((Object)string)) {
            return ((Set)this.nodesByLabel.get((Object)string)).size();
        }
        return 0;
    }

    public static class NodesIterator
    implements Iterator<Node> {
        final Node[] nodes;
        int idx = 0;
        Node nextPeeked = null;

        public NodesIterator(Node[] nodeArray) {
            this.nodes = nodeArray;
        }

        @Override
        public boolean hasNext() {
            while (this.nextPeeked == null && this.idx < this.nodes.length) {
                this.nextPeeked = this.nodes[this.idx++];
            }
            return this.nextPeeked != null;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node node = this.nextPeeked;
            this.nextPeeked = null;
            return node;
        }
    }
}

