/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

public class PackedIntArray {
    private static final byte BYTE_ARRAY = 0;
    private static final byte SHORT_ARRAY = 1;
    private static final byte INT_ARRAY = 2;
    private static final PackedIntArray EMPTY = new PackedIntArray(0);
    private byte kind = 0;
    private Object underlying;

    public static PackedIntArray create(int n) {
        if (n == 0) {
            return EMPTY;
        }
        return new PackedIntArray(n);
    }

    public static PackedIntArray of(int ... nArray) {
        if (nArray.length == 0) {
            return EMPTY;
        }
        return new PackedIntArray(nArray);
    }

    public PackedIntArray(int n) {
        this.underlying = this.getArrayAccessor(this.kind).allocate(n);
    }

    private ArrayAccessor getArrayAccessor(byte by) {
        switch (by) {
            case 0: {
                return ByteArrayAccessor.INSTANCE;
            }
            case 1: {
                return ShortArrayAccessor.INSTANCE;
            }
            case 2: {
                return IntArrayAccessor.INSTANCE;
            }
        }
        throw new IllegalStateException("PackedIntArray.kind has incorrect value.");
    }

    public PackedIntArray(int[] nArray) {
        this.underlying = this.getArrayAccessor(this.kind).allocate(nArray.length);
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, nArray[i]);
        }
    }

    public int length() {
        return this.getArrayAccessor(this.kind).length(this.underlying);
    }

    public int get(int n) {
        return this.getArrayAccessor(this.kind).get(this.underlying, n);
    }

    public void set(int n, int n2) {
        byte by = this.arrayKindForValue(n2);
        if (by > this.kind) {
            this.underlying = this.grow(by);
            this.kind = by;
        }
        this.getArrayAccessor(this.kind).set(this.underlying, n, n2);
    }

    private Object grow(byte by) {
        assert (this.kind < by);
        Object object = this.getArrayAccessor(by).allocate(this.length());
        for (int i = 0; i < this.length(); ++i) {
            this.getArrayAccessor(by).set(object, i, this.get(i));
        }
        return object;
    }

    private byte arrayKindForValue(int n) {
        if (n >= -128 && n <= 127) {
            return 0;
        }
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            return 1;
        }
        return 2;
    }

    public int[] toIntArray() {
        if (this.kind == 2) {
            return (int[])this.underlying;
        }
        return (int[])this.grow((byte)2);
    }

    private static class ByteArrayAccessor
    implements ArrayAccessor {
        static final ByteArrayAccessor INSTANCE = new ByteArrayAccessor();

        private ByteArrayAccessor() {
        }

        private byte[] cast(Object object) {
            return (byte[])object;
        }

        @Override
        public Object allocate(int n) {
            return new byte[n];
        }

        @Override
        public int get(Object object, int n) {
            return this.cast(object)[n];
        }

        @Override
        public void set(Object object, int n, int n2) {
            this.cast((Object)object)[n] = (byte)n2;
        }

        @Override
        public int length(Object object) {
            return this.cast(object).length;
        }
    }

    private static class ShortArrayAccessor
    implements ArrayAccessor {
        static final ShortArrayAccessor INSTANCE = new ShortArrayAccessor();

        private ShortArrayAccessor() {
        }

        private short[] cast(Object object) {
            return (short[])object;
        }

        @Override
        public Object allocate(int n) {
            return new short[n];
        }

        @Override
        public int get(Object object, int n) {
            return this.cast(object)[n];
        }

        @Override
        public void set(Object object, int n, int n2) {
            this.cast((Object)object)[n] = (short)n2;
        }

        @Override
        public int length(Object object) {
            return this.cast(object).length;
        }
    }

    private static class IntArrayAccessor
    implements ArrayAccessor {
        static final IntArrayAccessor INSTANCE = new IntArrayAccessor();

        private IntArrayAccessor() {
        }

        private int[] cast(Object object) {
            return (int[])object;
        }

        @Override
        public Object allocate(int n) {
            return new int[n];
        }

        @Override
        public int get(Object object, int n) {
            return this.cast(object)[n];
        }

        @Override
        public void set(Object object, int n, int n2) {
            this.cast((Object)object)[n] = n2;
        }

        @Override
        public int length(Object object) {
            return this.cast(object).length;
        }
    }

    static interface ArrayAccessor {
        public Object allocate(int var1);

        public int get(Object var1, int var2);

        public void set(Object var1, int var2, int var3);

        public int length(Object var1);
    }
}

