/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.traversal;

import java.io.Serializable;
import overflowdb.traversal.PathAwareTraversal;
import overflowdb.traversal.TraversalLogicExt;
import overflowdb.traversal.help.Doc;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class TraversalLogicExt$ {
    public static final TraversalLogicExt$ MODULE$ = new TraversalLogicExt$();

    @Doc(info="perform side effect without changing the contents of the traversal")
    public final <A> Iterator<A> sideEffect$extension(Iterator<A> $this, Function1<A, ?> fun) {
        Iterator<A> iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._sideEffect(fun);
        }
        return $this.map((Function1 & Serializable)a -> {
            fun.apply(a);
            return a;
        });
    }

    @Doc(info="perform side effect without changing the contents of the traversal")
    public final <A> Iterator<A> sideEffectPF$extension(Iterator<A> $this, PartialFunction<A, ?> pf) {
        return this.sideEffect$extension($this, pf.lift());
    }

    @Doc(info="only preserves elements if the provided traversal has at least one result")
    public final <A> Iterator<A> where$extension(Iterator<A> $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return $this.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)TraversalLogicExt$.$anonfun$where$1(trav, a)));
    }

    @Doc(info="only preserves elements if the provided traversal does _not_ have any results")
    public final <A> Iterator<A> whereNot$extension(Iterator<A> $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return $this.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)TraversalLogicExt$.$anonfun$whereNot$1(trav, a)));
    }

    @Doc(info="only preserves elements if the provided traversal does _not_ have any results - alias for whereNot")
    public final <A> Iterator<A> not$extension(Iterator<A> $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return this.whereNot$extension($this, trav);
    }

    @Doc(info="only preserves elements for which _at least one of_ the given traversals has at least one result")
    public final <A> Iterator<A> or$extension(Iterator<A> $this, Seq<Function1<Iterator<A>, Iterator<?>>> traversals) {
        return $this.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)traversals.exists((Function1 & Serializable)trav -> BoxesRunTime.boxToBoolean((boolean)TraversalLogicExt$.$anonfun$or$2(a, trav)))));
    }

    @Doc(info="only preserves elements for which _all of_ the given traversals have at least one result")
    public final <A> Iterator<A> and$extension(Iterator<A> $this, Seq<Function1<Iterator<A>, Iterator<?>>> traversals) {
        return $this.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)traversals.forall((Function1 & Serializable)trav -> BoxesRunTime.boxToBoolean((boolean)TraversalLogicExt$.$anonfun$and$2(a, trav)))));
    }

    @Doc(info="union/sum/aggregate/join given traversals from the current point")
    public final <B, A> Iterator<B> union$extension(Iterator<A> $this, Seq<Function1<Iterator<A>, Iterator<B>>> traversals) {
        Iterator<A> iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._union(traversals);
        }
        return $this.flatMap((Function1 & Serializable)a -> (Seq)traversals.flatMap((Function1 & Serializable)x$2 -> (Iterator)x$2.apply((Object)Iterator$.MODULE$.single(a))));
    }

    @Doc(info="allows to implement conditional semantics: if, if/else, if/elseif, if/elseif/else, ...")
    public final <BranchOn, NewEnd, A> Iterator<NewEnd> choose$extension(Iterator<A> $this, Function1<Iterator<A>, Iterator<BranchOn>> on, PartialFunction<BranchOn, Function1<Iterator<A>, Iterator<NewEnd>>> options) {
        Iterator<A> iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._choose(on, options);
        }
        return $this.flatMap((Function1 & Serializable)a -> {
            Object branchOnValue = ((Iterator)on.apply((Object)Iterator$.MODULE$.single(a))).nextOption().getOrElse((Function0 & Serializable)() -> null);
            return (Iterator)((Function1)options.applyOrElse(branchOnValue, (Function1 & Serializable)failState -> (Function1 & Serializable)unused -> Iterator$.MODULE$.empty())).apply((Object)Iterator$.MODULE$.single(a));
        });
    }

    @Doc(info="evaluates the provided traversals in order and returns the first traversal that emits at least one element")
    public final <NewEnd, A> Iterator<NewEnd> coalesce$extension(Iterator<A> $this, Seq<Function1<Iterator<A>, Iterator<NewEnd>>> options) {
        Iterator<A> iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._coalesce(options);
        }
        return $this.flatMap((Function1 & Serializable)a -> (Iterator)options.iterator().map((Function1 & Serializable)x$3 -> (Iterator)x$3.apply((Object)Iterator$.MODULE$.single(a))).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Iterator<NewEnd>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.nonEmpty()) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Iterator<NewEnd> x1) {
                Iterator<NewEnd> iterator = x1;
                return iterator.nonEmpty();
            }
        }).getOrElse((Function0 & Serializable)() -> Iterator$.MODULE$.empty()));
    }

    public final <A> int hashCode$extension(Iterator<A> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A> boolean equals$extension(Iterator<A> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof TraversalLogicExt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterator iterator = x$1 == null ? null : ((TraversalLogicExt)x$1).iterator();
        Iterator<A> iterator2 = $this;
        Iterator iterator3 = iterator;
        if (iterator2 != null) {
            if (!iterator2.equals(iterator3)) return false;
            return true;
        }
        if (iterator3 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$where$1(Function1 trav$1, Object a) {
        return ((Iterator)trav$1.apply((Object)Iterator$.MODULE$.single(a))).hasNext();
    }

    public static final /* synthetic */ boolean $anonfun$whereNot$1(Function1 trav$2, Object a) {
        return !((Iterator)trav$2.apply((Object)Iterator$.MODULE$.single(a))).hasNext();
    }

    public static final /* synthetic */ boolean $anonfun$or$2(Object a$1, Function1 trav) {
        return ((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a$1))).hasNext();
    }

    public static final /* synthetic */ boolean $anonfun$and$2(Object a$2, Function1 trav) {
        return ((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a$2))).hasNext();
    }

    private TraversalLogicExt$() {
    }
}

